/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.writer;

import io.quarkus.cli.commands.writer.ProjectWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileProjectWriter
implements ProjectWriter {
    private final File root;

    public FileProjectWriter(File file) {
        this.root = file;
    }

    @Override
    public boolean init() {
        boolean mkdirStatus;
        if (this.root.exists() && !this.root.isDirectory()) {
            System.out.println("Project root needs to either not exist or be a directory");
            return false;
        }
        if (!this.root.exists() && !(mkdirStatus = this.root.mkdirs())) {
            System.out.println("Failed to create root directory");
            return false;
        }
        System.out.println("Creating a new project in " + this.root.getAbsolutePath());
        return true;
    }

    @Override
    public String mkdirs(String path) {
        File dirToCreate = new File(this.root, path);
        if (!dirToCreate.exists()) {
            dirToCreate.mkdirs();
        }
        if (path.isEmpty()) {
            return "";
        }
        return dirToCreate.getPath().substring(this.root.getPath().length() + 1);
    }

    @Override
    public void write(String path, String content) throws IOException {
        Path outputPath = Paths.get(this.root + "/" + path, new String[0]);
        Files.write(outputPath, content.getBytes("UTF-8"), new OpenOption[0]);
    }

    @Override
    public byte[] getContent(String path) throws IOException {
        return Files.readAllBytes(Paths.get(this.root + "/" + path, new String[0]));
    }

    @Override
    public boolean exists(String path) {
        return new File(this.root, path).exists();
    }

    @Override
    public void close() throws IOException {
    }
}

