/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.utilities;

import java.io.File;

public class JavaBinFinder {
    public static String findBin() {
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File javaCheck = new File(java);
        if (!javaCheck.canExecute()) {
            java = null;
            if (OS.determineOS() == OS.WINDOWS && System.getenv().containsKey("PATHEXT")) {
                String[] exts;
                String extpath = System.getenv("PATHEXT");
                for (String ext : exts = extpath.split(";")) {
                    File winExe = new File(javaCheck.getAbsolutePath() + ext);
                    if (!winExe.canExecute()) continue;
                    java = winExe.getAbsolutePath();
                    break;
                }
            }
            if (java == null) {
                java = OS.determineOS() == OS.WINDOWS ? "java.exe" : "java";
            }
        }
        return java;
    }

    static enum OS {
        WINDOWS,
        LINUX,
        MAC,
        OTHER;

        private String version;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        static OS determineOS() {
            String osName = System.getProperty("os.name").toLowerCase();
            OS os = osName.contains("windows") ? WINDOWS : (osName.contains("linux") || osName.contains("freebsd") || osName.contains("unix") || osName.contains("sunos") || osName.contains("solaris") || osName.contains("aix") ? LINUX : (osName.contains("mac os") ? MAC : OTHER));
            os.setVersion(System.getProperty("os.version"));
            return os;
        }
    }
}

