/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.registry.catalog.model.Extension;
import io.quarkus.registry.catalog.model.Platform;
import io.quarkus.registry.catalog.model.Repository;
import io.quarkus.registry.catalog.spi.ArtifactResolver;
import io.quarkus.registry.catalog.spi.IndexVisitor;
import io.quarkus.registry.model.Release;
import java.io.IOException;
import java.util.Objects;

public class RepositoryIndexer {
    private final ArtifactResolver artifactResolver;

    public RepositoryIndexer(ArtifactResolver artifactResolver) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "Resolver cannot be null");
    }

    public void index(Repository repository, IndexVisitor visitor) throws IOException {
        for (Platform platform : repository.getPlatforms()) {
            for (Release release : platform.getReleases()) {
                QuarkusPlatformDescriptor descriptor = this.artifactResolver.resolvePlatform(platform, release);
                if (descriptor == null) continue;
                visitor.visitPlatform(descriptor);
            }
        }
        for (Extension extension : repository.getIndividualExtensions()) {
            for (Release release : extension.getReleases()) {
                io.quarkus.dependencies.Extension ext = this.artifactResolver.resolveExtension(extension, release);
                if (ext == null) continue;
                visitor.visitExtension(ext, release.getQuarkusCore());
            }
        }
    }
}

