/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.model.Extension;
import io.quarkus.registry.model.Release;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableExtension
implements Extension {
    private final String groupId;
    private final String artifactId;
    private final List<Release> releases;

    private ImmutableExtension(String groupId, String artifactId, List<Release> releases) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.releases = releases;
    }

    @Override
    @JsonProperty(value="group-id")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifact-id")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="releases")
    public List<Release> getReleases() {
        return this.releases;
    }

    public final ImmutableExtension withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableExtension(newValue, this.artifactId, this.releases);
    }

    public final ImmutableExtension withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutableExtension(this.groupId, newValue, this.releases);
    }

    public final ImmutableExtension withReleases(Release ... elements) {
        List<Release> newValue = ImmutableExtension.createUnmodifiableList(false, ImmutableExtension.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExtension(this.groupId, this.artifactId, newValue);
    }

    public final ImmutableExtension withReleases(Iterable<? extends Release> elements) {
        if (this.releases == elements) {
            return this;
        }
        List<Release> newValue = ImmutableExtension.createUnmodifiableList(false, ImmutableExtension.createSafeList(elements, true, false));
        return new ImmutableExtension(this.groupId, this.artifactId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtension && this.equalTo((ImmutableExtension)another);
    }

    private boolean equalTo(ImmutableExtension another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        return h;
    }

    public String toString() {
        return "Extension{groupId=" + this.groupId + ", artifactId=" + this.artifactId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableExtension fromJson(Json json) {
        Builder builder = ImmutableExtension.builder();
        if (json.groupId != null) {
            builder.groupId(json.groupId);
        }
        if (json.artifactId != null) {
            builder.artifactId(json.artifactId);
        }
        if (json.releases != null) {
            builder.addAllReleases(json.releases);
        }
        return builder.build();
    }

    public static ImmutableExtension copyOf(Extension instance) {
        if (instance instanceof ImmutableExtension) {
            return (ImmutableExtension)instance;
        }
        return ImmutableExtension.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private long initBits = 3L;
        private String groupId;
        private String artifactId;
        private List<Release> releases = new ArrayList<Release>();

        private Builder() {
        }

        public final Builder from(Extension instance) {
            Objects.requireNonNull(instance, "instance");
            this.groupId(instance.getGroupId());
            this.artifactId(instance.getArtifactId());
            this.addAllReleases(instance.getReleases());
            return this;
        }

        @JsonProperty(value="group-id")
        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="artifact-id")
        public final Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addReleases(Release element) {
            this.releases.add(Objects.requireNonNull(element, "releases element"));
            return this;
        }

        public final Builder addReleases(Release ... elements) {
            for (Release element : elements) {
                this.releases.add(Objects.requireNonNull(element, "releases element"));
            }
            return this;
        }

        @JsonProperty(value="releases")
        public final Builder releases(Iterable<? extends Release> elements) {
            this.releases.clear();
            return this.addAllReleases(elements);
        }

        public final Builder addAllReleases(Iterable<? extends Release> elements) {
            for (Release release : elements) {
                this.releases.add(Objects.requireNonNull(release, "releases element"));
            }
            return this;
        }

        public ImmutableExtension build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtension(this.groupId, this.artifactId, ImmutableExtension.createUnmodifiableList(true, this.releases));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build Extension, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Extension {
        String groupId;
        String artifactId;
        List<Release> releases = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="group-id")
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @JsonProperty(value="artifact-id")
        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        @JsonProperty(value="releases")
        public void setReleases(List<Release> releases) {
            this.releases = releases;
        }

        @Override
        public String getGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArtifactId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Release> getReleases() {
            throw new UnsupportedOperationException();
        }
    }
}

