/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.ArtifactCoords;
import io.quarkus.registry.model.ArtifactKey;
import io.quarkus.registry.model.ImmutableExtension;
import io.quarkus.registry.model.ImmutableExtensionPlatformRelease;
import io.quarkus.registry.model.ImmutableExtensionRelease;
import io.quarkus.registry.model.Nullable;
import io.quarkus.registry.model.Release;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableExtension.class)
@Value.Immutable
@Value.Modifiable
public interface Extension {
    @JsonUnwrapped
    public ArtifactKey getId();

    @Value.Auxiliary
    public String getName();

    @Value.Auxiliary
    @Nullable
    public String getDescription();

    @Value.Auxiliary
    public Map<String, Object> getMetadata();

    @Value.Auxiliary
    @Value.ReverseOrder
    public SortedSet<ExtensionRelease> getReleases();

    @JsonDeserialize(as=ImmutableExtensionPlatformRelease.class)
    @Value.Immutable
    public static interface ExtensionPlatformRelease {
        @JsonUnwrapped
        public ArtifactCoords getCoords();

        @Value.Auxiliary
        public Map<String, Object> getMetadata();
    }

    @JsonDeserialize(as=ImmutableExtensionRelease.class)
    @Value.Immutable
    @Value.Modifiable
    public static interface ExtensionRelease
    extends Comparable<ExtensionRelease> {
        @JsonUnwrapped
        public Release getRelease();

        @Value.Auxiliary
        public Set<ExtensionPlatformRelease> getPlatforms();

        @Override
        default public int compareTo(ExtensionRelease o) {
            return this.getRelease().compareTo(o.getRelease());
        }
    }
}

