/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.ListExtensionsCommandHandler;
import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.platform.tools.config.QuarkusPlatformConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.model.Dependency;

public class ListExtensions {
    public static final String NAME = "list-extensions";
    private static final String PARAM_PREFIX = ToolsUtils.dotJoin("quarkus", "list-extensions");
    public static final String ALL = ToolsUtils.dotJoin(PARAM_PREFIX, "all");
    public static final String FORMAT = ToolsUtils.dotJoin(PARAM_PREFIX, "format");
    public static final String SEARCH = ToolsUtils.dotJoin(PARAM_PREFIX, "search");
    private final QuarkusCommandInvocation invocation;
    private final ListExtensionsCommandHandler handler = new ListExtensionsCommandHandler();

    @Deprecated
    public ListExtensions(BuildFile buildFile) throws IOException {
        this(buildFile, QuarkusPlatformConfig.getGlobalDefault().getPlatformDescriptor());
    }

    public ListExtensions(BuildFile buildFile, QuarkusPlatformDescriptor platformDescr) throws IOException {
        this.invocation = new QuarkusCommandInvocation(platformDescr);
        if (buildFile != null) {
            this.invocation.setBuildFile(buildFile);
        }
    }

    public ListExtensions all(boolean all) {
        this.invocation.setValue(ALL, all);
        return this;
    }

    public ListExtensions format(String format) {
        this.invocation.setValue(FORMAT, format);
        return this;
    }

    public ListExtensions search(String search) {
        this.invocation.setValue(SEARCH, search);
        return this;
    }

    @Deprecated
    public void listExtensions(boolean all, String format, String search) throws IOException {
        this.all(all);
        this.format(format);
        this.search(search);
        try {
            this.execute();
        }
        catch (QuarkusCommandException e) {
            throw new IOException("Failed to list extensions", e);
        }
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return this.handler.execute(this.invocation);
    }

    public Map<String, Dependency> findInstalled() throws IOException {
        return this.handler.findInstalled(this.invocation);
    }
}

