/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.project.SourceType;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.paths.PathTree;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class CreateProjectHelper {
    public static final String DEFAULT_GROUP_ID = "org.acme";
    public static final String DEFAULT_ARTIFACT_ID = "code-with-quarkus";
    public static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";

    private CreateProjectHelper() {
    }

    public static ExtensionCatalog completeCatalogWithCoords(ExtensionCatalog catalog, Collection<ArtifactCoords> extensions, MavenArtifactResolver mvn) {
        List<String> exts = extensions.stream().filter(e -> e.getVersion() != null).map(Object::toString).collect(Collectors.toList());
        return CreateProjectHelper.completeCatalog(catalog, exts, mvn);
    }

    public static ExtensionCatalog completeCatalog(ExtensionCatalog catalog, Collection<String> extensions, MavenArtifactResolver mvn) {
        ExtensionCatalog.Mutable mutableCatalog = null;
        for (String extArg : extensions) {
            Path extJar;
            if (!CreateProjectHelper.isFullArtifactCoords(extArg)) continue;
            ArtifactCoords coords = ArtifactCoords.fromString((String)extArg.trim());
            try {
                extJar = mvn.resolve((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion())).getArtifact().getFile().toPath();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to resolve extension " + coords, e);
            }
            Extension ext = (Extension)PathTree.ofDirectoryOrArchive((Path)extJar).apply("META-INF/quarkus-extension.yaml", visit -> {
                if (visit == null) {
                    return null;
                }
                try {
                    return Extension.fromFile((Path)visit.getPath());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse Quarkus extension metadata " + visit.getPath());
                }
            });
            if (ext == null) continue;
            if (mutableCatalog == null) {
                mutableCatalog = catalog.mutable();
            }
            Iterator i = mutableCatalog.getExtensions().iterator();
            boolean add = true;
            while (i.hasNext()) {
                ArtifactCoords catalogCoords = ((Extension)i.next()).getArtifact();
                if (!catalogCoords.getKey().equals(ext.getArtifact().getKey())) continue;
                if (catalogCoords.getVersion().equals(ext.getArtifact().getVersion())) {
                    add = false;
                    break;
                }
                i.remove();
                break;
            }
            if (!add) continue;
            mutableCatalog.addExtension(ext);
        }
        if (mutableCatalog != null) {
            catalog = mutableCatalog.build();
        }
        return catalog;
    }

    private static boolean isFullArtifactCoords(String s) {
        if (s == null) {
            return false;
        }
        int firstColon = s.indexOf(58);
        if (firstColon > 0) {
            int lastColon = s.lastIndexOf(58);
            return lastColon > 0 && firstColon != lastColon;
        }
        return false;
    }

    public static String checkClassName(String name) {
        if (!SourceVersion.isName(name)) {
            throw new IllegalArgumentException(name + " is not a valid class name");
        }
        return name;
    }

    public static String checkPackageName(String name) {
        if (!SourceVersion.isName(name)) {
            throw new IllegalArgumentException(name + " is not a valid package name");
        }
        return name;
    }

    public static Path checkProjectRootPath(Path outputPath, String name) {
        Objects.requireNonNull(name, "Must specify project name");
        Objects.requireNonNull(outputPath, "Must specify output path");
        Path projectRootPath = outputPath.resolve(name);
        if (projectRootPath.toFile().exists()) {
            throw new IllegalArgumentException("Target directory already exists: " + projectRootPath.toAbsolutePath().toString());
        }
        return projectRootPath;
    }

    public static Path createOutputDirectory(String targetDirectory) {
        Path origin = new File(System.getProperty("user.dir")).toPath();
        Path outputPath = targetDirectory == null ? origin : origin.resolve(targetDirectory);
        try {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not create directory " + targetDirectory, e);
        }
        return outputPath;
    }

    public static Set<String> sanitizeExtensions(Set<String> extensions) {
        if (extensions == null) {
            extensions = Set.of();
            return extensions;
        }
        return extensions.stream().filter(Objects::nonNull).map(String::trim).collect(Collectors.toSet());
    }

    public static void addSourceTypeExtensions(Set<String> extensions, SourceType sourceType) {
        if (sourceType == SourceType.KOTLIN) {
            extensions.add("quarkus-kotlin");
        } else if (sourceType == SourceType.SCALA) {
            extensions.add("quarkus-scala");
        }
    }

    public static void handleSpringConfiguration(Map<String, Object> values) {
        Set extensions = (Set)values.get("project.extensions");
        CreateProjectHelper.handleSpringConfiguration(values, extensions);
    }

    public static void handleSpringConfiguration(Map<String, Object> values, Set<String> extensions) {
        Objects.requireNonNull(values, "Must provide values");
        Objects.requireNonNull(extensions, "Must provide extensions");
        if (CreateProjectHelper.containsSpringWeb(extensions) && CreateProjectHelper.containsRESTEasy(extensions)) {
            values.remove("project.resource.class-name");
            values.remove("project.resource.path");
        }
    }

    private static boolean containsSpringWeb(Collection<String> extensions) {
        return extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"));
    }

    private static boolean containsRESTEasy(Collection<String> extensions) {
        return extensions.isEmpty() || extensions.stream().anyMatch(e -> e.toLowerCase().contains("resteasy"));
    }
}

