/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigRoot;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadoc;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadocSection;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigAnnotationListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.documentation.config.util.JavadocUtil;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class AbstractJavadocConfigListener
implements ConfigAnnotationListener {
    protected final Config config;
    protected final Utils utils;
    protected final ConfigCollector configCollector;

    protected AbstractJavadocConfigListener(Config config, Utils utils, ConfigCollector configCollector) {
        this.config = config;
        this.utils = utils;
        this.configCollector = configCollector;
    }

    @Override
    public Optional<DiscoveryConfigRoot> onConfigRoot(TypeElement configRoot) {
        if (!this.utils.element().isLocalClass(configRoot)) {
            return Optional.empty();
        }
        Optional<String> rawJavadoc = this.utils.element().getJavadoc(configRoot);
        if (rawJavadoc.isEmpty()) {
            return Optional.empty();
        }
        ParsedJavadocSection parsedJavadocSection = JavadocUtil.parseConfigSectionJavadoc(rawJavadoc.get());
        if (parsedJavadocSection.title() == null) {
            return Optional.empty();
        }
        this.configCollector.addJavadocElement(configRoot.getQualifiedName().toString(), new JavadocElements.JavadocElement(parsedJavadocSection.title(), parsedJavadocSection.format(), null, parsedJavadocSection.deprecated()));
        return Optional.empty();
    }

    @Override
    public void onResolvedEnum(TypeElement enumTypeElement) {
        if (!this.utils.element().isLocalClass(enumTypeElement)) {
            return;
        }
        for (Element element : enumTypeElement.getEnclosedElements()) {
            ParsedJavadoc parsedJavadoc;
            Optional<String> rawJavadoc;
            if (element.getKind() != ElementKind.ENUM_CONSTANT || (rawJavadoc = this.utils.element().getJavadoc(element)).isEmpty() || (parsedJavadoc = JavadocUtil.parseConfigItemJavadoc(rawJavadoc.get())).description() == null) continue;
            this.configCollector.addJavadocElement(enumTypeElement.getQualifiedName().toString() + "." + element.getSimpleName().toString(), new JavadocElements.JavadocElement(parsedJavadoc.description(), parsedJavadoc.format(), parsedJavadoc.since(), parsedJavadoc.deprecated()));
        }
    }
}

