/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.devconsole;

import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainersSupplier;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Iterator;
import org.flywaydb.core.Flyway;

@Recorder
public class FlywayDevConsoleRecorder {
    public Handler<RoutingContext> handler() {
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String datasource = form.get("datasource");
                String operation = form.get("operation");
                Object liquibaseContainers = new FlywayContainersSupplier().get();
                Iterator iterator = liquibaseContainers.iterator();
                while (iterator.hasNext()) {
                    FlywayContainer flywayContainer = (FlywayContainer)iterator.next();
                    if (!flywayContainer.getDataSourceName().equals(datasource)) continue;
                    Flyway flyway = flywayContainer.getFlyway();
                    if ("clean".equals(operation)) {
                        flyway.clean();
                        this.flashMessage(event, "Database cleaned");
                        return;
                    }
                    if ("migrate".equals(operation)) {
                        flyway.migrate();
                        this.flashMessage(event, "Database migrated");
                        return;
                    }
                    this.flashMessage(event, "Invalid operation: " + operation, FlashScopeUtil.FlashMessageStatus.ERROR);
                    return;
                }
                this.flashMessage(event, "Datasource not found: " + datasource, FlashScopeUtil.FlashMessageStatus.ERROR);
            }
        };
    }
}

