/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockingServerInterceptor
implements ServerInterceptor {
    private final Vertx vertx;
    private final List<String> blockingMethods;
    private final Map<String, Boolean> cache = new HashMap<String, Boolean>();

    public BlockingServerInterceptor(Vertx vertx, List<String> blockingMethods) {
        this.vertx = vertx;
        this.blockingMethods = new ArrayList<String>();
        for (String method : blockingMethods) {
            this.blockingMethods.add(method.toLowerCase());
        }
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, final ServerCallHandler<ReqT, RespT> next) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        boolean isBlocking = this.cache.computeIfAbsent(fullMethodName, new Function<String, Boolean>(){

            @Override
            public Boolean apply(String name) {
                String methodName = name.substring(name.lastIndexOf("/") + 1);
                return BlockingServerInterceptor.this.blockingMethods.contains(methodName.toLowerCase());
            }
        });
        if (isBlocking) {
            final ReplayListener replay = new ReplayListener();
            this.vertx.executeBlocking((Handler)new Handler<Promise<Object>>(){

                public void handle(Promise<Object> f) {
                    ServerCall.Listener listener = next.startCall(call, headers);
                    replay.setDelegate(listener);
                    f.complete(null);
                }
            }, null);
            return replay;
        }
        return next.startCall(call, headers);
    }

    private class ReplayListener<ReqT>
    extends ServerCall.Listener<ReqT> {
        private ServerCall.Listener<ReqT> delegate;
        private final List<Consumer<ServerCall.Listener<ReqT>>> incomingEvents = new LinkedList<Consumer<ServerCall.Listener<ReqT>>>();

        private ReplayListener() {
        }

        synchronized void setDelegate(ServerCall.Listener<ReqT> delegate) {
            this.delegate = delegate;
            for (Consumer<ServerCall.Listener<ReqT>> event : this.incomingEvents) {
                event.accept(delegate);
            }
            this.incomingEvents.clear();
        }

        private synchronized void executeOnContextOrEnqueue(final Consumer<ServerCall.Listener<ReqT>> consumer) {
            if (this.delegate != null) {
                BlockingServerInterceptor.this.vertx.executeBlocking((Handler)new Handler<Promise<Object>>(){

                    public void handle(Promise<Object> f) {
                        consumer.accept(ReplayListener.this.delegate);
                        f.complete();
                    }
                }, true, null);
            } else {
                this.incomingEvents.add(consumer);
            }
        }

        public void onMessage(final ReqT message) {
            this.executeOnContextOrEnqueue(new Consumer<ServerCall.Listener<ReqT>>(){

                @Override
                public void accept(ServerCall.Listener<ReqT> t) {
                    t.onMessage(message);
                }
            });
        }

        public void onHalfClose() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onComplete);
        }

        public void onReady() {
            this.executeOnContextOrEnqueue(ServerCall.Listener::onReady);
        }
    }
}

