/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devmode;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.testing.GrpcWebSocketProxy;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.jboss.logging.Logger;

@Recorder
public class GrpcDevConsoleRecorder {
    private static final Logger log = Logger.getLogger(GrpcDevConsoleRecorder.class);

    public void setServerConfiguration() {
        try (InstanceHandle config = Arc.container().instance(GrpcConfiguration.class, new Annotation[0]);){
            GrpcServerConfiguration serverConfig = ((GrpcConfiguration)config.get()).server;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("host", serverConfig.host);
            map.put("port", serverConfig.port);
            map.put("ssl", serverConfig.ssl.certificate.isPresent() || serverConfig.ssl.keyStore.isPresent());
            DevConsoleManager.setGlobal((String)"io.quarkus.grpc.serverConfig", map);
        }
    }

    public Handler<RoutingContext> handler() {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext context) {
                context.request().toWebSocket(webSocket -> {
                    if (webSocket.failed()) {
                        log.error((Object)"failed to connect web socket", webSocket.cause());
                    } else {
                        ServerWebSocket serverWebSocket = (ServerWebSocket)webSocket.result();
                        final Integer socketId = GrpcWebSocketProxy.addWebSocket(message -> serverWebSocket.writeTextMessage(message).onFailure(e -> log.info((Object)"failed to send back message to the gRPC Dev Console WebSocket", e)), runnable -> {
                            if (!serverWebSocket.isClosed()) {
                                serverWebSocket.close((Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> event) {
                                        runnable.run();
                                    }
                                });
                            } else {
                                runnable.run();
                            }
                        });
                        if (socketId == null) {
                            log.error((Object)"No gRPC dev console WebSocketListener");
                            serverWebSocket.close();
                            return;
                        }
                        serverWebSocket.closeHandler(ignored -> GrpcWebSocketProxy.closeWebSocket((int)socketId));
                        serverWebSocket.handler((Handler)new Handler<Buffer>(){

                            public void handle(Buffer event) {
                                GrpcWebSocketProxy.addMessage((Integer)socketId, (String)event.toString());
                            }
                        });
                    }
                });
            }
        };
    }
}

