/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.entitymanager;

import io.quarkus.hibernate.orm.runtime.RequestScopedEntityManagerHolder;
import io.quarkus.runtime.BlockingOperationControl;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionScopedEntityManager
implements EntityManager {
    protected static final String TRANSACTION_IS_NOT_ACTIVE = "Transaction is not active, consider adding @Transactional to your method to automatically activate one.";
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final EntityManagerFactory entityManagerFactory;
    private final String unitName;
    private final String entityManagerKey;
    private final Instance<RequestScopedEntityManagerHolder> requestScopedEntityManagers;

    public TransactionScopedEntityManager(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, EntityManagerFactory entityManagerFactory, String unitName, Instance<RequestScopedEntityManagerHolder> requestScopedEntityManagers) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.entityManagerFactory = entityManagerFactory;
        this.unitName = unitName;
        this.entityManagerKey = this.getClass().getSimpleName() + "-" + unitName;
        this.requestScopedEntityManagers = requestScopedEntityManagers;
    }

    EntityManagerResult getEntityManager() {
        if (this.isInTransaction()) {
            EntityManager entityManager = (EntityManager)this.transactionSynchronizationRegistry.getResource((Object)this.entityManagerKey);
            if (entityManager != null) {
                return new EntityManagerResult(entityManager, false, true);
            }
            final EntityManager newEntityManager = this.entityManagerFactory.createEntityManager();
            newEntityManager.joinTransaction();
            this.transactionSynchronizationRegistry.putResource((Object)this.entityManagerKey, (Object)newEntityManager);
            this.transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    newEntityManager.flush();
                }

                public void afterCompletion(int i) {
                    newEntityManager.close();
                }
            });
            return new EntityManagerResult(newEntityManager, false, true);
        }
        RequestScopedEntityManagerHolder requestScopedEntityManagers = (RequestScopedEntityManagerHolder)this.requestScopedEntityManagers.get();
        return new EntityManagerResult(requestScopedEntityManagers.getOrCreateEntityManager(this.unitName, this.entityManagerFactory), false, false);
    }

    private void checkBlocking() {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new IllegalStateException("You have attempted to perform a blocking operation on a IO thread. This is not allowed, as blocking the IO thread will cause major performance issues with your application. If you want to perform blocking EntityManager operations make sure you are doing it from a worker thread.");
        }
    }

    private boolean isInTransaction() {
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void persist(Object entity) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.persist(entity);
        }
    }

    public <T> T merge(T entity) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            Object object = emr.entityManager.merge(entity);
            return (T)object;
        }
    }

    public void remove(Object entity) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.remove(entity);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.entityManager.find(entityClass, primaryKey);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.entityManager.find(entityClass, primaryKey, properties);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.entityManager.find(entityClass, primaryKey, lockMode);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.entityManager.find(entityClass, primaryKey, lockMode, properties);
            return (T)object;
        }
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.entityManager.getReference(entityClass, primaryKey);
            return (T)object;
        }
    }

    public void flush() {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.flush();
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.entityManager.setFlushMode(flushMode);
        }
    }

    public FlushModeType getFlushMode() {
        try (EntityManagerResult emr = this.getEntityManager();){
            FlushModeType flushModeType = emr.entityManager.getFlushMode();
            return flushModeType;
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.lock(entity, lockMode);
        }
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.lock(entity, lockMode, properties);
        }
    }

    public void refresh(Object entity) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.refresh(entity);
        }
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.refresh(entity, properties);
        }
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.refresh(entity, lockMode);
        }
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.entityManager.refresh(entity, lockMode, properties);
        }
    }

    public void clear() {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.entityManager.clear();
        }
    }

    public void detach(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.entityManager.detach(entity);
        }
    }

    public boolean contains(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            boolean bl = emr.entityManager.contains(entity);
            return bl;
        }
    }

    public LockModeType getLockMode(Object entity) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            LockModeType lockModeType = emr.entityManager.getLockMode(entity);
            return lockModeType;
        }
    }

    public void setProperty(String propertyName, Object value) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.entityManager.setProperty(propertyName, value);
        }
    }

    public Map<String, Object> getProperties() {
        try (EntityManagerResult emr = this.getEntityManager();){
            Map map = emr.entityManager.getProperties();
            return map;
        }
    }

    public Query createQuery(String qlString) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.entityManager.createQuery(qlString);
            return query;
        }
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            TypedQuery typedQuery = emr.entityManager.createQuery(criteriaQuery);
            return typedQuery;
        }
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.entityManager.createQuery(updateQuery);
            return query;
        }
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.entityManager.createQuery(deleteQuery);
            return query;
        }
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            TypedQuery typedQuery = emr.entityManager.createQuery(qlString, resultClass);
            return typedQuery;
        }
    }

    public Query createNamedQuery(String name) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.entityManager.createNamedQuery(name);
            return query;
        }
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            TypedQuery typedQuery = emr.entityManager.createNamedQuery(name, resultClass);
            return typedQuery;
        }
    }

    public Query createNativeQuery(String sqlString) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.entityManager.createNativeQuery(sqlString);
            return query;
        }
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.entityManager.createNativeQuery(sqlString, resultClass);
            return query;
        }
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.entityManager.createNativeQuery(sqlString, resultSetMapping);
            return query;
        }
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.entityManager.createNamedStoredProcedureQuery(name);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.entityManager.createStoredProcedureQuery(procedureName);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.entityManager.createStoredProcedureQuery(procedureName, resultClasses);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.entityManager.createStoredProcedureQuery(procedureName, resultSetMappings);
            return storedProcedureQuery;
        }
    }

    public void joinTransaction() {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.entityManager.joinTransaction();
        }
    }

    public boolean isJoinedToTransaction() {
        try (EntityManagerResult emr = this.getEntityManager();){
            boolean bl = emr.entityManager.isJoinedToTransaction();
            return bl;
        }
    }

    public <T> T unwrap(Class<T> cls) {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.entityManager.unwrap(cls);
            return (T)object;
        }
    }

    public Object getDelegate() {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.entityManager.getDelegate();
            return object;
        }
    }

    public void close() {
        throw new IllegalStateException("Not supported for transaction scoped entity managers");
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Not supported for JTA entity managers");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityManagerFactory entityManagerFactory = emr.entityManager.getEntityManagerFactory();
            return entityManagerFactory;
        }
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.checkBlocking();
        try (EntityManagerResult emr = this.getEntityManager();){
            CriteriaBuilder criteriaBuilder = emr.entityManager.getCriteriaBuilder();
            return criteriaBuilder;
        }
    }

    public Metamodel getMetamodel() {
        try (EntityManagerResult emr = this.getEntityManager();){
            Metamodel metamodel = emr.entityManager.getMetamodel();
            return metamodel;
        }
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityGraph entityGraph = emr.entityManager.createEntityGraph(rootType);
            return entityGraph;
        }
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityGraph entityGraph = emr.entityManager.createEntityGraph(graphName);
            return entityGraph;
        }
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityGraph entityGraph = emr.entityManager.getEntityGraph(graphName);
            return entityGraph;
        }
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        try (EntityManagerResult emr = this.getEntityManager();){
            List list = emr.entityManager.getEntityGraphs(entityClass);
            return list;
        }
    }

    static class EntityManagerResult
    implements AutoCloseable {
        final EntityManager entityManager;
        final boolean closeOnEnd;
        final boolean allowModification;

        EntityManagerResult(EntityManager entityManager, boolean closeOnEnd, boolean allowModification) {
            this.entityManager = entityManager;
            this.closeOnEnd = closeOnEnd;
            this.allowModification = allowModification;
        }

        @Override
        public void close() {
            if (this.closeOnEnd) {
                this.entityManager.close();
            }
        }
    }
}

