/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.orm.runtime.Hibernate;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.JPAConfigSupport;
import io.quarkus.hibernate.orm.runtime.PersistenceProviderSetup;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.hibernate.orm.runtime.TransactionEntityManagers;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.entitymanager.ForwardingEntityManager;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.tenant.DataSourceTenantConnectionResolver;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.integrator.spi.Integrator;
import org.jboss.logging.Logger;

@Recorder
public class HibernateOrmRecorder {
    private List<String> entities = new ArrayList<String>();

    public void enlistPersistenceUnit(Set<String> entityClassNames) {
        this.entities.addAll(entityClassNames);
        Logger.getLogger((String)"io.quarkus.hibernate.orm").debugf("List of entities found by Quarkus deployment:%n%s", this.entities);
    }

    public void callHibernateFeatureInit(boolean enabled) {
        Hibernate.featureInit(enabled);
    }

    public void setupPersistenceProvider(HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig) {
        PersistenceProviderSetup.registerRuntimePersistenceProvider(hibernateOrmRuntimeConfig);
    }

    public BeanContainerListener initMetadata(final List<QuarkusPersistenceUnitDefinition> parsedPersistenceXmlDescriptors, final Scanner scanner, final Collection<Class<? extends Integrator>> additionalIntegrators, final PreGeneratedProxies proxyDefinitions) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                PersistenceUnitsHolder.initializeJpa(parsedPersistenceXmlDescriptors, scanner, additionalIntegrators, proxyDefinitions);
            }
        };
    }

    public Supplier<JPAConfigSupport> jpaConfigSupportSupplier(final JPAConfigSupport jpaConfigSupport) {
        return new Supplier<JPAConfigSupport>(){

            @Override
            public JPAConfigSupport get() {
                return jpaConfigSupport;
            }
        };
    }

    public Supplier<DataSourceTenantConnectionResolver> dataSourceTenantConnectionResolver(final String persistenceUnitName, final String dataSourceName, final MultiTenancyStrategy multiTenancyStrategy, final String multiTenancySchemaDataSourceName) {
        return new Supplier<DataSourceTenantConnectionResolver>(){

            @Override
            public DataSourceTenantConnectionResolver get() {
                return new DataSourceTenantConnectionResolver(persistenceUnitName, dataSourceName, multiTenancyStrategy, multiTenancySchemaDataSourceName);
            }
        };
    }

    public void startAllPersistenceUnits(BeanContainer beanContainer) {
        ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).startAll();
    }

    public Supplier<EntityManagerFactory> entityManagerFactorySupplier(final String persistenceUnitName) {
        return new Supplier<EntityManagerFactory>(){

            @Override
            public EntityManagerFactory get() {
                EntityManagerFactory entityManagerFactory = ((JPAConfig)Arc.container().instance(JPAConfig.class, new Annotation[0]).get()).getEntityManagerFactory(persistenceUnitName);
                return entityManagerFactory;
            }
        };
    }

    public Supplier<EntityManager> entityManagerSupplier(final String persistenceUnitName) {
        return new Supplier<EntityManager>(){

            @Override
            public EntityManager get() {
                final TransactionEntityManagers transactionEntityManagers = (TransactionEntityManagers)Arc.container().instance(TransactionEntityManagers.class, new Annotation[0]).get();
                ForwardingEntityManager entityManager = new ForwardingEntityManager(){

                    @Override
                    protected EntityManager delegate() {
                        return transactionEntityManagers.getEntityManager(persistenceUnitName);
                    }
                };
                return entityManager;
            }
        };
    }
}

