/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.validator.runtime.ArcConstraintValidatorFactoryImpl;
import io.quarkus.hibernate.validator.runtime.ArcProxyBeanMetaDataClassNormalizer;
import io.quarkus.hibernate.validator.runtime.ValidatorHolder;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.PredefinedScopeHibernateValidator;
import org.hibernate.validator.PredefinedScopeHibernateValidatorConfiguration;
import org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

@Recorder
public class HibernateValidatorRecorder {
    public BeanContainerListener initializeValidatorFactory(final Set<Class<?>> classesToBeValidated, final ShutdownContext shutdownContext, final LocalesBuildTimeConfig localesBuildTimeConfig) {
        BeanContainerListener beanContainerListener = new BeanContainerListener(){

            public void created(BeanContainer container) {
                InstanceHandle configuredGetterPropertySelectionStrategy;
                InstanceHandle configuredScriptEvaluatorFactory;
                InstanceHandle configuredClockProvider;
                InstanceHandle configuredParameterNameProvider;
                InstanceHandle configuredTraversableResolver;
                PredefinedScopeHibernateValidatorConfiguration configuration = (PredefinedScopeHibernateValidatorConfiguration)Validation.byProvider(PredefinedScopeHibernateValidator.class).configure();
                LocaleResolver localeResolver = null;
                InstanceHandle configuredLocaleResolver = Arc.container().instance(LocaleResolver.class, new Annotation[0]);
                if (configuredLocaleResolver.isAvailable()) {
                    localeResolver = (LocaleResolver)configuredLocaleResolver.get();
                    configuration.localeResolver(localeResolver);
                }
                ((PredefinedScopeHibernateValidatorConfiguration)((PredefinedScopeHibernateValidatorConfiguration)configuration.initializeBeanMetaData(classesToBeValidated).locales(localesBuildTimeConfig.locales)).defaultLocale(localesBuildTimeConfig.defaultLocale)).beanMetaDataClassNormalizer((BeanMetaDataClassNormalizer)new ArcProxyBeanMetaDataClassNormalizer());
                InstanceHandle configuredConstraintValidatorFactory = Arc.container().instance(ConstraintValidatorFactory.class, new Annotation[0]);
                if (configuredConstraintValidatorFactory.isAvailable()) {
                    configuration.constraintValidatorFactory((ConstraintValidatorFactory)configuredConstraintValidatorFactory.get());
                } else {
                    configuration.constraintValidatorFactory((ConstraintValidatorFactory)new ArcConstraintValidatorFactoryImpl());
                }
                InstanceHandle configuredMessageInterpolator = Arc.container().instance(MessageInterpolator.class, new Annotation[0]);
                if (configuredMessageInterpolator.isAvailable()) {
                    configuration.messageInterpolator((MessageInterpolator)configuredMessageInterpolator.get());
                }
                if ((configuredTraversableResolver = Arc.container().instance(TraversableResolver.class, new Annotation[0])).isAvailable()) {
                    configuration.traversableResolver((TraversableResolver)configuredTraversableResolver.get());
                }
                if ((configuredParameterNameProvider = Arc.container().instance(ParameterNameProvider.class, new Annotation[0])).isAvailable()) {
                    configuration.parameterNameProvider((ParameterNameProvider)configuredParameterNameProvider.get());
                }
                if ((configuredClockProvider = Arc.container().instance(ClockProvider.class, new Annotation[0])).isAvailable()) {
                    configuration.clockProvider((ClockProvider)configuredClockProvider.get());
                }
                if ((configuredScriptEvaluatorFactory = Arc.container().instance(ScriptEvaluatorFactory.class, new Annotation[0])).isAvailable()) {
                    configuration.scriptEvaluatorFactory((ScriptEvaluatorFactory)configuredScriptEvaluatorFactory.get());
                }
                if ((configuredGetterPropertySelectionStrategy = Arc.container().instance(GetterPropertySelectionStrategy.class, new Annotation[0])).isAvailable()) {
                    configuration.getterPropertySelectionStrategy((GetterPropertySelectionStrategy)configuredGetterPropertySelectionStrategy.get());
                }
                for (ValueExtractor valueExtractor : Arc.container().beanManager().createInstance().select(ValueExtractor.class, new Annotation[0])) {
                    configuration.addValueExtractor(valueExtractor);
                }
                final ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
                ValidatorHolder.initialize(validatorFactory);
                shutdownContext.addShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        validatorFactory.close();
                    }
                });
            }
        };
        return beanContainerListener;
    }
}

