/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class AppModel
implements Serializable {
    private static final Logger log = Logger.getLogger(AppModel.class);
    private final AppArtifact appArtifact;
    private final List<AppDependency> deploymentDeps;
    private final List<AppDependency> fullDeploymentDeps;
    private final List<AppDependency> runtimeDeps;
    private final Set<AppArtifactKey> parentFirstArtifacts;
    private final Set<AppArtifactKey> lesserPriorityArtifacts;

    private AppModel(AppArtifact appArtifact, List<AppDependency> runtimeDeps, List<AppDependency> deploymentDeps, List<AppDependency> fullDeploymentDeps, Set<AppArtifactKey> parentFirstArtifacts, Set<AppArtifactKey> lesserPriorityArtifacts) {
        this.appArtifact = appArtifact;
        this.runtimeDeps = runtimeDeps;
        this.deploymentDeps = deploymentDeps;
        this.fullDeploymentDeps = fullDeploymentDeps;
        this.parentFirstArtifacts = parentFirstArtifacts;
        this.lesserPriorityArtifacts = lesserPriorityArtifacts;
    }

    public AppArtifact getAppArtifact() {
        return this.appArtifact;
    }

    public List<AppDependency> getUserDependencies() {
        return this.runtimeDeps;
    }

    @Deprecated
    public List<AppDependency> getDeploymentDependencies() {
        return this.deploymentDeps;
    }

    public List<AppDependency> getFullDeploymentDeps() {
        return this.fullDeploymentDeps;
    }

    public Set<AppArtifactKey> getParentFirstArtifacts() {
        return this.parentFirstArtifacts;
    }

    public Set<AppArtifactKey> getLesserPriorityArtifacts() {
        return this.lesserPriorityArtifacts;
    }

    public String toString() {
        return "AppModel{appArtifact=" + this.appArtifact + ", deploymentDeps=" + this.deploymentDeps + ", fullDeploymentDeps=" + this.fullDeploymentDeps + ", runtimeDeps=" + this.runtimeDeps + ", parentFirstArtifacts=" + this.parentFirstArtifacts + '}';
    }

    public static class Builder {
        private AppArtifact appArtifact;
        private final List<AppDependency> deploymentDeps = new ArrayList<AppDependency>();
        private final List<AppDependency> fullDeploymentDeps = new ArrayList<AppDependency>();
        private final List<AppDependency> runtimeDeps = new ArrayList<AppDependency>();
        private final Set<AppArtifactKey> parentFirstArtifacts = new HashSet<AppArtifactKey>();
        private final Set<AppArtifactKey> excludedArtifacts = new HashSet<AppArtifactKey>();
        private final Set<AppArtifactKey> lesserPriorityArtifacts = new HashSet<AppArtifactKey>();

        public Builder setAppArtifact(AppArtifact appArtifact) {
            this.appArtifact = appArtifact;
            return this;
        }

        public Builder addDeploymentDep(AppDependency dep) {
            this.deploymentDeps.add(dep);
            return this;
        }

        public Builder addDeploymentDeps(List<AppDependency> deps) {
            this.deploymentDeps.addAll(deps);
            return this;
        }

        public Builder addFullDeploymentDep(AppDependency dep) {
            this.fullDeploymentDeps.add(dep);
            return this;
        }

        public Builder addFullDeploymentDeps(List<AppDependency> deps) {
            this.fullDeploymentDeps.addAll(deps);
            return this;
        }

        public Builder addRuntimeDep(AppDependency dep) {
            this.runtimeDeps.add(dep);
            return this;
        }

        public Builder addRuntimeDeps(List<AppDependency> deps) {
            this.runtimeDeps.addAll(deps);
            return this;
        }

        public Builder addParentFirstArtifact(AppArtifactKey deps) {
            this.parentFirstArtifacts.add(deps);
            return this;
        }

        public Builder addParentFirstArtifacts(List<AppArtifactKey> deps) {
            this.parentFirstArtifacts.addAll(deps);
            return this;
        }

        public Builder addExcludedArtifact(AppArtifactKey deps) {
            this.excludedArtifacts.add(deps);
            return this;
        }

        public Builder addExcludedArtifacts(List<AppArtifactKey> deps) {
            this.excludedArtifacts.addAll(deps);
            return this;
        }

        public void handleExtensionProperties(Properties props, String extension) {
            String lesserPriority;
            String excluded;
            String parentFirst = props.getProperty("parent-first-artifacts");
            if (parentFirst != null) {
                String[] artifacts;
                for (String artifact : artifacts = parentFirst.split(",")) {
                    this.parentFirstArtifacts.add(new AppArtifactKey(artifact.split(":")));
                }
            }
            if ((excluded = props.getProperty("excluded-artifacts")) != null) {
                String[] artifacts;
                for (String artifact : artifacts = excluded.split(",")) {
                    this.excludedArtifacts.add(new AppArtifactKey(artifact.split(":")));
                    log.debugf("Extension %s is excluding %s", (Object)extension, (Object)artifact);
                }
            }
            if ((lesserPriority = props.getProperty("lesser-priority-artifacts")) != null) {
                String[] artifacts;
                for (String artifact : artifacts = lesserPriority.split(",")) {
                    this.lesserPriorityArtifacts.add(new AppArtifactKey(artifact.split(":")));
                    log.debugf("Extension %s is making %s a lesser priority artifact", (Object)extension, (Object)artifact);
                }
            }
        }

        public AppModel build() {
            Predicate<AppDependency> includePredicate = s -> {
                if (s.getArtifact().getGroupId().equals("io.quarkus") && s.getArtifact().getArtifactId().equals("quarkus-ide-launcher")) {
                    return false;
                }
                return !this.excludedArtifacts.contains(s.getArtifact().getKey());
            };
            List runtimeDeps = this.runtimeDeps.stream().filter(includePredicate).collect(Collectors.toList());
            List deploymentDeps = this.deploymentDeps.stream().filter(includePredicate).collect(Collectors.toList());
            List fullDeploymentDeps = this.fullDeploymentDeps.stream().filter(includePredicate).collect(Collectors.toList());
            AppModel appModel = new AppModel(this.appArtifact, runtimeDeps, deploymentDeps, fullDeploymentDeps, this.parentFirstArtifacts, this.lesserPriorityArtifacts);
            log.debugf("Created AppModel %s", (Object)appModel);
            return appModel;
        }
    }
}

