/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.transport.wagon;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.transport.wagon.WagonProvider;

@Named(value="plexus")
@Singleton
public class PlexusWagonProvider
implements WagonProvider {
    private PlexusContainer container;

    @Inject
    public PlexusWagonProvider(PlexusContainer container) {
        this.container = Objects.requireNonNull(container, "plexus container cannot be null");
    }

    @Override
    public Wagon lookup(String roleHint) throws Exception {
        return this.container.lookup(Wagon.class, roleHint);
    }

    @Override
    public void release(Wagon wagon) {
        try {
            if (wagon != null) {
                this.container.release(wagon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

