/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class QuarkusLauncher {
    public static void launch(String callingClass, String quarkusApplication, Consumer<Integer> exitHandler, String ... args) {
        try {
            String classResource = callingClass.replace(".", "/") + ".class";
            URL resource = Thread.currentThread().getContextClassLoader().getResource(classResource);
            String path = resource.getPath();
            path = path.substring(0, path.length() - classResource.length());
            URL newResource = new URL(resource.getProtocol(), resource.getHost(), resource.getPort(), path);
            Path appClasses = Paths.get(newResource.toURI());
            if (quarkusApplication != null) {
                System.setProperty("quarkus.package.main-class", quarkusApplication);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("app-classes", appClasses);
            context.put("args", args);
            IDEClassLoader loader = new IDEClassLoader(QuarkusLauncher.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> launcher = loader.loadClass("io.quarkus.bootstrap.IDELauncherImpl");
            launcher.getDeclaredMethod("launch", Path.class, Map.class).invoke(null, appClasses, context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            System.clearProperty("quarkus-internal.serialized-app-model.path");
        }
    }

    public static class IDEClassLoader
    extends ClassLoader {
        public IDEClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            String resourceName = name.replace(".", "/") + ".class";
            try (InputStream is = this.getResourceAsStream(resourceName);){
                int r;
                if (is == null) {
                    throw new ClassNotFoundException(name);
                }
                this.definePackage(name);
                byte[] buf = new byte[1024];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((r = is.read(buf)) > 0) {
                    out.write(buf, 0, r);
                }
                byte[] bytes = out.toByteArray();
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void definePackage(String name) {
            String pkgName = this.getPackageNameFromClassName(name);
            if (pkgName != null && this.getPackage(pkgName) == null) {
                Object object = this.getClassLoadingLock(pkgName);
                synchronized (object) {
                    if (this.getPackage(pkgName) == null) {
                        this.definePackage(pkgName, null, null, null, null, null, null, null);
                    }
                }
            }
        }

        private String getPackageNameFromClassName(String className) {
            int index = className.lastIndexOf(46);
            if (index == -1) {
                return null;
            }
            return className.substring(0, index);
        }

        @Override
        protected Class<?> findClass(String moduleName, String name) {
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        @Override
        protected URL findResource(String moduleName, String name) throws IOException {
            return this.findResource(name);
        }

        @Override
        protected URL findResource(String name) {
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            return this.getParent().getResource("META-INF/ide-deps" + name + ".ide-launcher-res");
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            return this.getParent().getResources("META-INF/ide-deps" + name + ".ide-launcher-res");
        }

        static {
            IDEClassLoader.registerAsParallelCapable();
        }
    }
}

