/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.quarkus.jaeger.runtime.JaegerConfig;
import io.quarkus.jaeger.runtime.QuarkusJaegerTracer;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Recorder
public class JaegerDeploymentRecorder {
    private static volatile boolean registered;
    private static final Logger log;

    public void registerTracer(JaegerConfig jaeger) {
        if (!registered) {
            if (this.isValidConfig(jaeger)) {
                this.initTracerConfig(jaeger);
                QuarkusJaegerTracer quarkusJaegerTracer = new QuarkusJaegerTracer();
                log.debugf("Registering tracer to GlobalTracer %s", (Object)quarkusJaegerTracer);
                GlobalTracer.register((Tracer)quarkusJaegerTracer);
            }
            registered = true;
        }
    }

    private boolean isValidConfig(JaegerConfig jaeger) {
        Config mpconfig = ConfigProvider.getConfig();
        Optional serviceName = mpconfig.getOptionalValue("JAEGER_SERVICE_NAME", String.class);
        if (jaeger.serviceName.isPresent() || serviceName.isPresent()) {
            return true;
        }
        log.warn((Object)"Jaeger service name has not been defined, either as 'quarkus.jaeger.service-name' application property or JAEGER_SERVICE_NAME environment variable/system property");
        return false;
    }

    private void initTracerConfig(JaegerConfig jaeger) {
        this.initTracerProperty("JAEGER_ENDPOINT", jaeger.endpoint, uri -> uri.toString());
        this.initTracerProperty("JAEGER_AUTH_TOKEN", jaeger.authToken, token -> token);
        this.initTracerProperty("JAEGER_USER", jaeger.user, user -> user);
        this.initTracerProperty("JAEGER_PASSWORD", jaeger.password, pw -> pw);
        this.initTracerProperty("JAEGER_AGENT_HOST", jaeger.agentHostPort, address -> address.getHostName());
        this.initTracerProperty("JAEGER_AGENT_PORT", jaeger.agentHostPort, address -> String.valueOf(address.getPort()));
        this.initTracerProperty("JAEGER_REPORTER_LOG_SPANS", jaeger.reporterLogSpans, log -> log.toString());
        this.initTracerProperty("JAEGER_REPORTER_MAX_QUEUE_SIZE", jaeger.reporterMaxQueueSize, size -> size.toString());
        this.initTracerProperty("JAEGER_REPORTER_FLUSH_INTERVAL", jaeger.reporterFlushInterval, duration -> String.valueOf(duration.toMillis()));
        this.initTracerProperty("JAEGER_SAMPLER_TYPE", jaeger.samplerType, type -> type);
        this.initTracerProperty("JAEGER_SAMPLER_PARAM", jaeger.samplerParam, param -> param.toString());
        this.initTracerProperty("JAEGER_SAMPLER_MANAGER_HOST_PORT", jaeger.samplerManagerHostPort, hostPort -> hostPort.toString());
        this.initTracerProperty("JAEGER_SERVICE_NAME", jaeger.serviceName, name -> name);
        this.initTracerProperty("JAEGER_TAGS", jaeger.tags, tags -> tags.toString());
        this.initTracerProperty("JAEGER_PROPAGATION", jaeger.propagation, format -> format.toString());
        this.initTracerProperty("JAEGER_SENDER_FACTORY", jaeger.senderFactory, sender -> sender);
        this.initTracerProperty("JAEGER_LOG_TRACE_CONTEXT", Optional.of(jaeger.logTraceContext), logTraceContext -> logTraceContext.toString());
    }

    private <T> void initTracerProperty(String property, Optional<T> value, Function<T, String> accessor2) {
        if (value.isPresent()) {
            System.setProperty(property, accessor2.apply(value.get()));
        }
    }

    static {
        log = Logger.getLogger(JaegerDeploymentRecorder.class);
    }
}

