/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.JaegerSpanContext;
import io.opentracing.Scope;
import io.opentracing.Span;
import org.jboss.logging.MDC;

public class MDCScope
implements Scope {
    private static final String TRACE_ID = "traceId";
    private static final String SPAN_ID = "spanId";
    private static final String SAMPLED = "sampled";
    private final Scope wrapped;

    public MDCScope(Scope scope) {
        this.wrapped = scope;
        if (scope.span().context() instanceof JaegerSpanContext) {
            this.putContext((JaegerSpanContext)scope.span().context());
        }
    }

    public void close() {
        this.wrapped.close();
        MDC.remove((String)TRACE_ID);
        MDC.remove((String)SPAN_ID);
        MDC.remove((String)SAMPLED);
    }

    public Span span() {
        return this.wrapped.span();
    }

    protected void putContext(JaegerSpanContext spanContext) {
        MDC.put((String)TRACE_ID, (Object)spanContext.getTraceId());
        MDC.put((String)SPAN_ID, (Object)String.format("%16x", spanContext.getSpanId()));
        MDC.put((String)SAMPLED, (Object)Boolean.toString(spanContext.isSampled()));
    }
}

