/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.runtime;

import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.ext.ParamConverterProvider;
import org.jboss.resteasy.reactive.client.impl.ClientProxies;
import org.jboss.resteasy.reactive.client.impl.ClientSerialisers;
import org.jboss.resteasy.reactive.common.core.GenericTypeMapping;
import org.jboss.resteasy.reactive.common.core.Serialisers;

@Recorder
public class JaxrsClientReactiveRecorder
extends ResteasyReactiveCommonRecorder {
    private static volatile Serialisers serialisers;
    private static volatile GenericTypeMapping genericTypeMapping;
    private static volatile ClientProxies clientProxies;

    public static ClientProxies getClientProxies() {
        return clientProxies;
    }

    public static Serialisers getSerialisers() {
        return serialisers;
    }

    public static GenericTypeMapping getGenericTypeMapping() {
        return genericTypeMapping;
    }

    public void setupClientProxies(Map<String, RuntimeValue<BiFunction<WebTarget, List<ParamConverterProvider>, ?>>> clientImplementations, Map<String, String> failures) {
        clientProxies = this.createClientImpls(clientImplementations, failures);
    }

    public Serialisers createSerializers() {
        ClientSerialisers s = new ClientSerialisers();
        s.registerBuiltins(RuntimeType.CLIENT);
        serialisers = s;
        return s;
    }

    private ClientProxies createClientImpls(Map<String, RuntimeValue<BiFunction<WebTarget, List<ParamConverterProvider>, ?>>> clientImplementations, Map<String, String> failureMessages) {
        HashMap<Class, BiFunction> map = new HashMap<Class, BiFunction>();
        for (Map.Entry<String, RuntimeValue<BiFunction<WebTarget, List<ParamConverterProvider>, ?>>> entry : clientImplementations.entrySet()) {
            map.put(JaxrsClientReactiveRecorder.loadClass((String)entry.getKey()), (BiFunction)entry.getValue().getValue());
        }
        HashMap<Class, String> failures = new HashMap<Class, String>();
        for (Map.Entry<String, String> entry : failureMessages.entrySet()) {
            failures.put(JaxrsClientReactiveRecorder.loadClass((String)entry.getKey()), entry.getValue());
        }
        return new ClientProxies(map, failures);
    }

    public void setGenericTypeMapping(GenericTypeMapping typeMapping) {
        genericTypeMapping = typeMapping;
    }

    public void registerInvocationHandlerGenericType(GenericTypeMapping genericTypeMapping, String invocationHandlerClass, String resolvedType) {
        genericTypeMapping.addInvocationCallback(JaxrsClientReactiveRecorder.loadClass((String)invocationHandlerClass), JaxrsClientReactiveRecorder.loadClass((String)resolvedType));
    }

    static {
        clientProxies = new ClientProxies(Collections.emptyMap(), Collections.emptyMap());
    }
}

