/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.model.gradle.QuarkusModel;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.bootstrap.util.PathsUtils;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.enterprise.inject.Alternative;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AbstractJvmQuarkusTestExtension {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected ClassLoader originalCl;
    protected static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    protected static final Deque<Class<?>> currentTestClassStack;

    protected PrepareResult createAugmentor(ExtensionContext context, Class<? extends QuarkusTestProfile> profile, Collection<Runnable> shutdownTasks) throws Exception {
        CuratedApplication curatedApplication;
        Path outputDir;
        Class requiredTestClass = context.getRequiredTestClass();
        Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass);
        Path appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((String)testClassLocation.toString());
        PathsCollection.Builder rootBuilder = PathsCollection.builder();
        if (!appClassLocation.equals(testClassLocation)) {
            rootBuilder.add(testClassLocation);
            Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
            if (testResourcesLocation != null) {
                rootBuilder.add(testResourcesLocation);
            }
        }
        this.originalCl = Thread.currentThread().getContextClassLoader();
        HashMap<String, String> sysPropRestore = new HashMap<String, String>();
        sysPropRestore.put("quarkus.test.profile", System.getProperty("quarkus.test.profile"));
        System.clearProperty("test.url");
        HashMap<String, String> additional = new HashMap<String, String>();
        QuarkusTestProfile profileInstance = null;
        if (profile != null) {
            profileInstance = profile.getConstructor(new Class[0]).newInstance(new Object[0]);
            additional.putAll(profileInstance.getConfigOverrides());
            if (!profileInstance.getEnabledAlternatives().isEmpty()) {
                additional.put("quarkus.arc.selected-alternatives", profileInstance.getEnabledAlternatives().stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if (profileInstance.disableApplicationLifecycleObservers()) {
                additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
            }
            if (profileInstance.getConfigProfile() != null) {
                additional.put("quarkus.test.profile", profileInstance.getConfigProfile());
            }
            shutdownTasks.add(() -> ((RestorableSystemProperties)RestorableSystemProperties.setProperties(additional, (String[])new String[0])).close());
        }
        Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
        try {
            outputDir = projectRoot.resolve(projectRoot.relativize(testClassLocation).getName(0));
        }
        catch (Exception e) {
            outputDir = projectRoot;
        }
        rootBuilder.add(appClassLocation);
        Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
        if (appResourcesLocation != null) {
            rootBuilder.add(appResourcesLocation);
        }
        if (System.getProperty("quarkus-internal-test.serialized-app-model.path") == null) {
            QuarkusModel model = BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot);
            if (model != null) {
                PathsCollection classDirectories = PathsUtils.toPathsCollection((Collection)model.getWorkspace().getMainModule().getSourceSet().getSourceDirectories());
                for (Path classes : classDirectories) {
                    if (!Files.exists(classes, new LinkOption[0]) || rootBuilder.contains(classes)) continue;
                    rootBuilder.add(classes);
                }
            }
        } else if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
            PathsCollection sourceDirectories;
            for (PathsCollection sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                Path directory = Paths.get((String)sourceDirectory, new String[0]);
                if (!Files.exists(directory, new LinkOption[0]) || rootBuilder.contains(directory)) continue;
                rootBuilder.add(directory);
            }
        }
        if (CurrentTestApplication.curatedApplication != null) {
            curatedApplication = CurrentTestApplication.curatedApplication;
        } else {
            QuarkusBootstrap.Builder runnerBuilder = QuarkusBootstrap.builder().setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST);
            runnerBuilder.setTargetDirectory(outputDir);
            runnerBuilder.setProjectRoot(projectRoot);
            runnerBuilder.setApplicationRoot(rootBuilder.build());
            curatedApplication = runnerBuilder.setTest(true).build().bootstrap();
            shutdownTasks.add(() -> ((CuratedApplication)curatedApplication).close());
        }
        if (curatedApplication.getAppModel().getUserDependencies().isEmpty()) {
            throw new RuntimeException("The tests were run against a directory that does not contain a Quarkus project. Please ensure that the test is configured to use the proper working directory.");
        }
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Class)requiredTestClass);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Class)requiredTestClass);
        Timing.staticInitStarted((ClassLoader)curatedApplication.getBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TEST_LOCATION, testClassLocation);
        props.put(TEST_CLASS, requiredTestClass);
        quarkusTestProfile = profile;
        return new PrepareResult(curatedApplication.createAugmentor(QuarkusTestExtension.TestBuildChainFunction.class.getName(), props), profileInstance, curatedApplication);
    }

    protected Class<? extends QuarkusTestProfile> getQuarkusTestProfile(ExtensionContext extensionContext) {
        TestProfile annotation = extensionContext.getRequiredTestClass().getAnnotation(TestProfile.class);
        Class<? extends QuarkusTestProfile> selectedProfile = null;
        if (annotation != null) {
            selectedProfile = annotation.value();
        }
        return selectedProfile;
    }

    static {
        currentTestClassStack = new ArrayDeque();
    }

    protected static class PrepareResult {
        protected final AugmentAction augmentAction;
        protected final QuarkusTestProfile profileInstance;
        protected final CuratedApplication curatedApplication;

        public PrepareResult(AugmentAction augmentAction, QuarkusTestProfile profileInstance, CuratedApplication curatedApplication) {
            this.augmentAction = augmentAction;
            this.profileInstance = profileInstance;
            this.curatedApplication = curatedApplication;
        }
    }
}

