/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.deployment.dev.testing.LogCapturingOutputFilter;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.testing.TracingHandler;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.junit.AbstractJvmQuarkusTestExtension;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.main.Launch;
import io.quarkus.test.junit.main.LaunchResult;
import io.quarkus.test.junit.main.QuarkusMainIntegrationTest;
import io.quarkus.test.junit.main.QuarkusMainLauncher;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.BiPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class QuarkusMainTestExtension
extends AbstractJvmQuarkusTestExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver,
BeforeAllCallback,
AfterAllCallback {
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"io.quarkus.test.main.jvm"});
    private static Map<String, String> devServicesProps;
    AbstractJvmQuarkusTestExtension.PrepareResult prepareResult;
    private static boolean hasPerTestResources;
    LaunchResult result;

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.isIntegrationTest(context.getRequiredTestClass())) {
            return;
        }
        Class<? extends QuarkusTestProfile> profile = this.getQuarkusTestProfile(context);
        this.ensurePrepared(context, profile);
        Launch launch = context.getRequiredTestMethod().getAnnotation(Launch.class);
        if (launch != null) {
            String[] arguments = launch.value();
            LaunchResult r = this.doLaunch(context, profile, arguments);
            Assertions.assertEquals((int)launch.exitCode(), (int)r.exitCode(), (String)("Exit code did not match, output: " + r.getOutput() + " " + r.getErrorOutput()));
            this.result = r;
        }
    }

    private void ensurePrepared(ExtensionContext extensionContext, Class<? extends QuarkusTestProfile> profile) throws Exception {
        boolean reloadTestResources;
        ExtensionContext.Store store = extensionContext.getStore(ExtensionContext.Namespace.GLOBAL);
        QuarkusTestExtension.ExtensionState state = (QuarkusTestExtension.ExtensionState)store.get((Object)QuarkusTestExtension.ExtensionState.class.getName(), QuarkusTestExtension.ExtensionState.class);
        boolean wrongProfile = !Objects.equals(profile, quarkusTestProfile);
        boolean bl = reloadTestResources = !Objects.equals(extensionContext.getRequiredTestClass(), currentJUnitTestClass) && (hasPerTestResources || QuarkusMainTestExtension.hasPerTestResources(extensionContext));
        if (wrongProfile || reloadTestResources) {
            if (state != null) {
                try {
                    state.close();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.prepareResult = null;
        }
        if (this.prepareResult == null) {
            AbstractJvmQuarkusTestExtension.PrepareResult result;
            LinkedBlockingDeque<Runnable> shutdownTasks = new LinkedBlockingDeque<Runnable>();
            this.prepareResult = result = this.createAugmentor(extensionContext, profile, shutdownTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LaunchResult doLaunch(ExtensionContext context, Class<? extends QuarkusTestProfile> selectedProfile, String[] arguments) throws Exception {
        this.ensurePrepared(context, selectedProfile);
        QuarkusConsole.installRedirects();
        LogCapturingOutputFilter filter = new LogCapturingOutputFilter(this.prepareResult.curatedApplication, false, false, () -> true);
        QuarkusConsole.addOutputFilter((BiPredicate)filter);
        try {
            final int result = this.doJavaStart(context, selectedProfile, arguments);
            final List<String> out = Arrays.asList(String.join((CharSequence)"", filter.captureOutput()).replaceAll("\\u001B\\[(.*?)[a-zA-Z]", "").split("\n"));
            final List<String> err = Arrays.asList(String.join((CharSequence)"", filter.captureErrorOutput()).replaceAll("\\u001B\\[(.*?)[a-zA-Z]", "").split("\n"));
            LaunchResult launchResult = new LaunchResult(){

                @Override
                public List<String> getOutputStream() {
                    return out;
                }

                @Override
                public List<String> getErrorStream() {
                    return err;
                }

                @Override
                public int exitCode() {
                    return result;
                }
            };
            return launchResult;
        }
        finally {
            QuarkusConsole.removeOutputFilter((BiPredicate)filter);
            Thread.currentThread().setContextClassLoader(this.originalCl);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.result = null;
    }

    private int doJavaStart(ExtensionContext context, Class<? extends QuarkusTestProfile> profile, String[] arguments) throws Exception {
        TracingHandler.quarkusStarting();
        Closeable testResourceManager = null;
        try {
            StartupAction startupAction = this.prepareResult.augmentAction.createInitialRuntimeApplication();
            Thread.currentThread().setContextClassLoader(startupAction.getClassLoader());
            QuarkusTestProfile profileInstance = this.prepareResult.profileInstance;
            testResourceManager = (Closeable)startupAction.getClassLoader().loadClass(TestResourceManager.class.getName()).getConstructor(Class.class, Class.class, List.class, Boolean.TYPE, Map.class, Optional.class).newInstance(context.getRequiredTestClass(), profile != null ? profile : null, IntegrationTestUtil.getAdditionalTestResources(profileInstance, startupAction.getClassLoader()), profileInstance != null && profileInstance.disableGlobalTestResources(), startupAction.getDevServicesProperties(), Optional.empty());
            testResourceManager.getClass().getMethod("init", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            Map properties = (Map)testResourceManager.getClass().getMethod("start", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            startupAction.overrideConfig(properties);
            hasPerTestResources = (Boolean)testResourceManager.getClass().getMethod("hasPerTestResources", new Class[0]).invoke((Object)testResourceManager, new Object[0]);
            int n = startupAction.runMainClassBlocking(arguments);
            return n;
        }
        catch (Throwable e) {
            try {
                if (testResourceManager != null) {
                    testResourceManager.close();
                }
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        finally {
            if (this.originalCl != null) {
                Thread.currentThread().setContextClassLoader(this.originalCl);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.isIntegrationTest(extensionContext.getRequiredTestClass())) {
            return false;
        }
        Class<?> type = parameterContext.getParameter().getType();
        return type == LaunchResult.class || type == QuarkusMainLauncher.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, final ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        final Class<? extends QuarkusTestProfile> profile = this.getQuarkusTestProfile(extensionContext);
        if (type == LaunchResult.class) {
            return this.result;
        }
        if (type == QuarkusMainLauncher.class) {
            return new QuarkusMainLauncher(){

                @Override
                public LaunchResult launch(String ... args) {
                    try {
                        return QuarkusMainTestExtension.this.doLaunch(extensionContext, profile, args);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        throw new RuntimeException("Parameter type not supported");
    }

    private boolean isIntegrationTest(Class<?> clazz) {
        for (Class i : currentTestClassStack) {
            if (!i.isAnnotationPresent(QuarkusMainIntegrationTest.class)) continue;
            return true;
        }
        return clazz.isAnnotationPresent(QuarkusMainIntegrationTest.class);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        currentTestClassStack.pop();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        QuarkusConsole.installRedirects();
        currentTestClassStack.push(context.getRequiredTestClass());
    }
}

