/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.util;

import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.util.Comparator;
import java.util.Optional;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.ClassOrdererContext;

public class QuarkusTestProfileAwareClassOrderer
implements ClassOrderer {
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST = "20_";
    protected static final String DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "40_";
    protected static final String DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST = "60_";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST = "quarkus.test.orderer.prefix.quarkus-test";
    static final String CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE = "quarkus.test.orderer.prefix.quarkus-test-with-profile";
    static final String CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST = "quarkus.test.orderer.prefix.non-quarkus-test";

    public void orderClasses(ClassOrdererContext context) {
        if (context.getClassDescriptors().size() <= 1) {
            return;
        }
        String prefixQuarkusTest = context.getConfigurationParameter(CFGKEY_ORDER_PREFIX_QUARKUS_TEST).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST);
        String prefixQuarkusTestWithProfile = context.getConfigurationParameter(CFGKEY_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE).orElse(DEFAULT_ORDER_PREFIX_QUARKUS_TEST_WITH_PROFILE);
        String prefixNonQuarkusTest = context.getConfigurationParameter(CFGKEY_ORDER_PREFIX_NON_QUARKUS_TEST).orElse(DEFAULT_ORDER_PREFIX_NON_QUARKUS_TEST);
        context.getClassDescriptors().sort(Comparator.comparing(classDescriptor -> {
            Optional<String> customOrderKey = this.getCustomOrderKey((ClassDescriptor)classDescriptor, context);
            if (customOrderKey.isPresent()) {
                return customOrderKey.get();
            }
            String testClassName = classDescriptor.getTestClass().getName();
            if (classDescriptor.isAnnotated(QuarkusTest.class) || classDescriptor.isAnnotated(QuarkusIntegrationTest.class)) {
                return classDescriptor.findAnnotation(TestProfile.class).map(TestProfile::value).map(profileClass -> prefixQuarkusTestWithProfile + profileClass.getName() + "@" + testClassName).orElseGet(() -> prefixQuarkusTest + testClassName);
            }
            return prefixNonQuarkusTest + testClassName;
        }));
    }

    protected Optional<String> getCustomOrderKey(ClassDescriptor classDescriptor, ClassOrdererContext context) {
        return Optional.empty();
    }
}

