/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime;

import io.quarkus.runtime.annotations.Recorder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import org.xerial.snappy.OSInfo;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyLoader;

@Recorder
public class KafkaRecorder {
    public void loadSnappy() {
        String snappyNativeLibraryName = System.mapLibraryName("snappyjava");
        String snappyNativeLibraryPath = "/org/xerial/snappy/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
        boolean hasNativeLib = KafkaRecorder.hasResource(snappyNativeLibraryPath + "/" + snappyNativeLibraryName);
        if (!hasNativeLib && OSInfo.getOSName().equals("Mac")) {
            String altName = "libsnappyjava.jnilib";
            if (KafkaRecorder.hasResource(snappyNativeLibraryPath + "/" + altName)) {
                snappyNativeLibraryName = altName;
                hasNativeLib = true;
            }
        }
        if (!hasNativeLib) {
            String errorMessage = String.format("no native library is found for os.name=%s and os.arch=%s", OSInfo.getOSName(), OSInfo.getArchName());
            throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, errorMessage);
        }
        File out = KafkaRecorder.extractLibraryFile(SnappyLoader.class.getResource(snappyNativeLibraryPath + "/" + snappyNativeLibraryName), snappyNativeLibraryName);
        System.load(out.getAbsolutePath());
    }

    private static boolean hasResource(String path) {
        return SnappyLoader.class.getResource(path) != null;
    }

    private static File extractLibraryFile(URL library, String name) {
        String tmp = System.getProperty("java.io.tmpdir");
        File extractedLibFile = new File(tmp, name);
        try (BufferedInputStream inputStream = new BufferedInputStream(library.openStream());
             FileOutputStream fileOS = new FileOutputStream(extractedLibFile);){
            int byteContent;
            byte[] data = new byte[8192];
            while ((byteContent = inputStream.read(data, 0, 8192)) != -1) {
                fileOS.write(data, 0, byteContent);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to extract native library " + name + " to " + extractedLibFile.getAbsolutePath(), e);
        }
        extractedLibFile.deleteOnExit();
        return extractedLibFile;
    }
}

