/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.utils.Clients;
import io.dekorate.utils.Serialization;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NamespaceableResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.OpenShiftClient;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageCapabilitiesUtil;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.DeploymentResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.deployment.KubernetesClientErrorHandler;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.deployment.DeploymentTargetEntry;
import io.quarkus.kubernetes.deployment.EnabledKubernetesDeploymentTargetsBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.deployment.OpenshiftConfig;
import io.quarkus.kubernetes.deployment.PreventImplicitContainerImagePushBuildItem;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentClusterBuildItem;
import io.quarkus.kubernetes.spi.KubernetesOptionalResourceDefinitionBuildItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class KubernetesDeployer {
    private static final Logger log = Logger.getLogger(KubernetesDeployer.class);
    private static final String CONTAINER_IMAGE_EXTENSIONS_STR = ContainerImageCapabilitiesUtil.CAPABILITY_TO_EXTENSION_NAME.values().stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class})
    public void selectDeploymentTarget(ContainerImageInfoBuildItem containerImageInfo, EnabledKubernetesDeploymentTargetsBuildItem targets, Capabilities capabilities, ContainerImageConfig containerImageConfig, BuildProducer<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, BuildProducer<PreventImplicitContainerImagePushBuildItem> preventImplicitContainerImagePush) {
        Optional activeContainerImageCapability = ContainerImageCapabilitiesUtil.getActiveContainerImageCapability((Capabilities)capabilities);
        if (activeContainerImageCapability.isEmpty()) {
            return;
        }
        DeploymentTargetEntry selectedTarget = this.determineDeploymentTarget(containerImageInfo, targets, (String)activeContainerImageCapability.get(), containerImageConfig);
        selectedDeploymentTarget.produce((BuildItem)new SelectedKubernetesDeploymentTargetBuildItem(selectedTarget));
        if ("minikube".equals(selectedTarget.getName()) || "kind".equals(selectedTarget.getName())) {
            preventImplicitContainerImagePush.produce((BuildItem)new PreventImplicitContainerImagePushBuildItem());
        }
    }

    @BuildStep
    public void checkEnvironment(Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, KubernetesClientBuildItem client, List<GeneratedKubernetesResourceBuildItem> resources, BuildProducer<KubernetesDeploymentClusterBuildItem> deploymentCluster) {
        if (!KubernetesDeploy.INSTANCE.checkSilently()) {
            return;
        }
        String target = selectedDeploymentTarget.map(s -> s.getEntry().getName()).orElse("kubernetes");
        if (target.equals("kubernetes")) {
            deploymentCluster.produce((BuildItem)new KubernetesDeploymentClusterBuildItem("kubernetes"));
        }
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class})
    public void deploy(KubernetesClientBuildItem kubernetesClient, Capabilities capabilities, List<KubernetesDeploymentClusterBuildItem> deploymentClusters, Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, OutputTargetBuildItem outputTarget, OpenshiftConfig openshiftConfig, ApplicationInfoBuildItem applicationInfo, List<KubernetesOptionalResourceDefinitionBuildItem> optionalResourceDefinitions, BuildProducer<DeploymentResultBuildItem> deploymentResult, List<ArtifactResultBuildItem> artifactResults) {
        if (!KubernetesDeploy.INSTANCE.check()) {
            return;
        }
        if (selectedDeploymentTarget.isEmpty()) {
            if (ContainerImageCapabilitiesUtil.getActiveContainerImageCapability((Capabilities)capabilities).isEmpty()) {
                throw new RuntimeException("A Kubernetes deployment was requested but no extension was found to build a container image. Consider adding one of following extensions: " + CONTAINER_IMAGE_EXTENSIONS_STR + ".");
            }
            return;
        }
        KubernetesClient client = Clients.fromConfig((Object)kubernetesClient.getClient().getConfiguration());
        deploymentResult.produce((BuildItem)this.deploy(selectedDeploymentTarget.get().getEntry(), client, outputTarget.getOutputDirectory(), openshiftConfig, applicationInfo, optionalResourceDefinitions));
    }

    private DeploymentTargetEntry determineDeploymentTarget(ContainerImageInfoBuildItem containerImageInfo, EnabledKubernetesDeploymentTargetsBuildItem targets, String activeContainerImageCapability, ContainerImageConfig containerImageConfig) {
        Config config;
        DeploymentTargetEntry selectedTarget;
        boolean checkForMissingRegistry = true;
        boolean checkForNamespaceGroupAlignment = false;
        List<String> userSpecifiedDeploymentTargets = KubernetesConfigUtil.getExplictilyDeploymentTargets();
        if (userSpecifiedDeploymentTargets.isEmpty()) {
            selectedTarget = targets.getEntriesSortedByPriority().get(0);
            if (targets.getEntriesSortedByPriority().size() > 1) {
                log.info((Object)("Selecting target '" + selectedTarget.getName() + "' since it has the highest priority among the implicitly enabled deployment targets"));
            }
        } else {
            String firstUserSpecifiedDeploymentTarget = userSpecifiedDeploymentTargets.get(0);
            selectedTarget = targets.getEntriesSortedByPriority().stream().filter(d -> d.getName().equals(firstUserSpecifiedDeploymentTarget)).findFirst().orElseThrow(() -> new IllegalArgumentException("The specified value '" + firstUserSpecifiedDeploymentTarget + "' is not one of the allowed values of \"quarkus.kubernetes.deployment-target\""));
            if (userSpecifiedDeploymentTargets.size() > 1) {
                log.info((Object)("Only the first deployment target (which is '" + firstUserSpecifiedDeploymentTarget + "') selected via \"quarkus.kubernetes.deployment-target\" will be deployed"));
            }
        }
        if ("openshift".equals(selectedTarget.getName())) {
            boolean bl = checkForMissingRegistry = "io.quarkus.container.image.s2i".equals(activeContainerImageCapability) || "io.quarkus.container.image.openshift".equals(activeContainerImageCapability);
            if (!targets.getEntriesSortedByPriority().get(0).getKind().equals("DeploymentConfig")) {
                checkForNamespaceGroupAlignment = true;
            }
        } else if ("minikube".equals(selectedTarget.getName()) || "kind".equals(selectedTarget.getName())) {
            checkForMissingRegistry = false;
        } else if (containerImageConfig.isPushExplicitlyDisabled()) {
            checkForMissingRegistry = false;
        }
        if (checkForMissingRegistry && !containerImageInfo.getRegistry().isPresent()) {
            log.warn((Object)"A Kubernetes deployment was requested, but the container image to be built will not be pushed to any registry because \"quarkus.container-image.registry\" has not been set. The Kubernetes deployment will only work properly if the cluster is using the local Docker daemon. For that reason 'ImagePullPolicy' is being force-set to 'IfNotPresent'.");
        }
        if (checkForNamespaceGroupAlignment && (config = Config.autoConfigure(null)).getNamespace() != null && !config.getNamespace().equals(containerImageInfo.getGroup())) {
            log.warn((Object)("An openshift deployment was requested, but the container image group:" + containerImageInfo.getGroup() + " is not aligned with the currently selected project:" + config.getNamespace() + ".it is strongly advised to align them, or else the image might not be reachable."));
        }
        return selectedTarget;
    }

    private DeploymentResultBuildItem deploy(DeploymentTargetEntry deploymentTarget, KubernetesClient client, Path outputDir, OpenshiftConfig openshiftConfig, ApplicationInfoBuildItem applicationInfo, List<KubernetesOptionalResourceDefinitionBuildItem> optionalResourceDefinitions) {
        DeploymentResultBuildItem deploymentResultBuildItem;
        String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
        log.info((Object)("Deploying to " + deploymentTarget.getName().toLowerCase() + " server: " + client.getMasterUrl() + " in namespace: " + namespace + "."));
        File manifest = outputDir.resolve("kubernetes").resolve(deploymentTarget.getName().toLowerCase() + ".yml").toFile();
        FileInputStream fis = new FileInputStream(manifest);
        try {
            KubernetesList list = Serialization.unmarshalAsList((InputStream)fis);
            list.getItems().stream().filter(KubernetesDeployer.distinctByResourceKey()).forEach(i -> {
                if (i instanceof GenericKubernetesResource) {
                    GenericKubernetesResource genericResource = (GenericKubernetesResource)i;
                    ResourceDefinitionContext context = KubernetesDeployer.getGenericResourceContext(client, genericResource).orElseThrow(() -> new IllegalStateException("Could not retrieve API resource information for:" + i.getApiVersion() + " " + i.getKind() + ". Is the CRD for the resource available?"));
                    ((Resource)client.genericKubernetesResources(context).resource((Object)genericResource)).createOrReplace();
                } else {
                    NamespaceableResource r = client.resource(i);
                    if (KubernetesDeployer.shouldDeleteExisting(deploymentTarget, i)) {
                        r.delete();
                        try {
                            r.waitUntilCondition(Objects::isNull, 10L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            if (e instanceof InterruptedException) {
                                throw e;
                            }
                            log.warn((Object)("Failed to wait for the deletion of: " + i.getApiVersion() + " " + i.getKind() + " " + i.getMetadata().getName() + ". Is the resource waitable?"));
                        }
                    }
                    try {
                        r.createOrReplace();
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            throw e;
                        }
                        if (KubernetesDeployer.isOptional(optionalResourceDefinitions, i)) {
                            log.warn((Object)("Failed to apply: " + i.getKind() + " " + i.getMetadata().getName() + ", possibly due to missing a CRD apiVersion: " + i.getApiVersion() + " and kind: " + i.getKind() + "."));
                        }
                        throw e;
                    }
                }
                log.info((Object)("Applied: " + i.getKind() + " " + i.getMetadata().getName() + "."));
            });
            this.printExposeInformation(client, list, openshiftConfig, applicationInfo);
            HasMetadata m = list.getItems().stream().filter(r -> r.getKind().equals(deploymentTarget.getKind())).findFirst().orElseThrow(() -> new IllegalStateException("No " + deploymentTarget.getKind() + " found under: " + manifest.getAbsolutePath()));
            deploymentResultBuildItem = new DeploymentResultBuildItem(m.getMetadata().getName(), m.getMetadata().getLabels());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Can't find generated kubernetes manifest: " + manifest.getAbsolutePath());
            }
            catch (KubernetesClientException e) {
                KubernetesClientErrorHandler.handle((Exception)((Object)e));
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing file: " + manifest.getAbsolutePath());
            }
        }
        fis.close();
        return deploymentResultBuildItem;
    }

    private void printExposeInformation(KubernetesClient client, KubernetesList list, OpenshiftConfig openshiftConfig, ApplicationInfoBuildItem applicationInfo) {
        String generatedRouteName = ResourceNameUtil.getResourceName(openshiftConfig, applicationInfo);
        List items = list.getItems();
        for (HasMetadata item : items) {
            if (!"route.openshift.io/v1".equals(item.getApiVersion()) || !"Route".equals(item.getKind()) || !generatedRouteName.equals(item.getMetadata().getName())) continue;
            try {
                OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
                Route route = (Route)((Resource)openShiftClient.routes().withName(generatedRouteName)).get();
                boolean isTLS = route.getSpec().getTls() != null;
                String host = route.getSpec().getHost();
                log.infov("The deployed application can be accessed at: http{0}://{1}", (Object)(isTLS ? "s" : ""), (Object)host);
            }
            catch (KubernetesClientException kubernetesClientException) {}
            break;
        }
    }

    private static Optional<ResourceDefinitionContext> getGenericResourceContext(KubernetesClient client, GenericKubernetesResource resource) {
        APIResourceList apiResourceList = client.getApiResources(resource.getApiVersion());
        if (apiResourceList == null || apiResourceList.getResources() == null || apiResourceList.getResources().isEmpty()) {
            return Optional.empty();
        }
        return client.getApiResources(resource.getApiVersion()).getResources().stream().filter(r -> r.getKind().equals(resource.getKind())).map(r -> new ResourceDefinitionContext.Builder().withGroup(ApiVersionUtil.trimGroup((String)resource.getApiVersion())).withVersion(ApiVersionUtil.trimVersion((String)resource.getApiVersion())).withKind(r.getKind()).withNamespaced(r.getNamespaced().booleanValue()).withPlural(r.getName()).build()).findFirst();
    }

    private static boolean isOptional(List<KubernetesOptionalResourceDefinitionBuildItem> optionalResourceDefinitions, HasMetadata resource) {
        return optionalResourceDefinitions.stream().anyMatch(t -> t.getApiVersion().equals(resource.getApiVersion()) && t.getKind().equals(resource.getKind()));
    }

    private static boolean shouldDeleteExisting(DeploymentTargetEntry deploymentTarget, HasMetadata resource) {
        return "knative".equalsIgnoreCase(deploymentTarget.getName()) || resource instanceof Service || Objects.equals("v1", resource.getApiVersion()) && Objects.equals("Service", resource.getKind());
    }

    private static Predicate<HasMetadata> distinctByResourceKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(t.getApiVersion() + "/" + t.getKind() + ":" + t.getMetadata().getName(), Boolean.TRUE) == null;
    }
}

