/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.EditableImageConfiguration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.RemoveFromSelectorDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.openshift.decorator.ApplyReplicasDecorator;
import io.dekorate.project.Project;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfigBuilder;
import io.dekorate.s2i.decorator.AddBuilderImageStreamResourceDecorator;
import io.dekorate.s2i.decorator.AddDockerImageStreamResourceDecorator;
import io.fabric8.kubernetes.client.Config;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.FallbackContainerImageRegistryBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.deployment.AddDeploymentResourceDecorator;
import io.quarkus.kubernetes.deployment.AddNodePortDecorator;
import io.quarkus.kubernetes.deployment.AddPortToOpenshiftConfig;
import io.quarkus.kubernetes.deployment.AddStatefulSetResourceDecorator;
import io.quarkus.kubernetes.deployment.ApplyBuilderImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyExpositionConfigurator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyImageGroupConfigurator;
import io.quarkus.kubernetes.deployment.ApplyImageRegistryConfigurator;
import io.quarkus.kubernetes.deployment.ApplyReplicasToStatefulSetDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.DisableS2iConfigurator;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.OpenshiftConfig;
import io.quarkus.kubernetes.deployment.RemoveBuilderImageResourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveDeploymentConfigResourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveDeploymentTriggerDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromConfigMapEnvSourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromConfigMapKeySelectorDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromSecretEnvSourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromSecretKeySelectorDecorator;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class OpenshiftProcessor {
    private static final int OPENSHIFT_PRIORITY = 0;
    private static final String OPENSHIFT_INTERNAL_REGISTRY = "image-registry.openshift-image-registry.svc:5000";

    @BuildStep
    public void checkOpenshift(ApplicationInfoBuildItem applicationInfo, OpenshiftConfig config, BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets, BuildProducer<KubernetesResourceMetadataBuildItem> resourceMeta) {
        List<String> targets = KubernetesConfigUtil.getUserSpecifiedDeploymentTargets();
        boolean openshiftEnabled = targets.contains("openshift");
        String kind = config.getDepoymentResourceKind();
        String group = config.getDepoymentResourceGroup();
        String version = config.getDepoymentResourceVersion();
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("openshift", kind, group, version, 0, openshiftEnabled));
        if (openshiftEnabled) {
            String name = ResourceNameUtil.getResourceName(config, applicationInfo);
            resourceMeta.produce((BuildItem)new KubernetesResourceMetadataBuildItem("openshift", group, version, kind, name));
        }
    }

    @BuildStep
    public void populateInternalRegistry(OpenshiftConfig openshiftConfig, ContainerImageConfig containerImageConfig, BuildProducer<FallbackContainerImageRegistryBuildItem> containerImageRegistry) {
        if (openshiftConfig.deploymentKind == OpenshiftConfig.DeploymentResourceKind.Deployment && !containerImageConfig.registry.isPresent()) {
            containerImageRegistry.produce((BuildItem)new FallbackContainerImageRegistryBuildItem(OPENSHIFT_INTERNAL_REGISTRY));
            String group = containerImageConfig.group.orElse(null);
            Config config = Config.autoConfigure(null);
        }
    }

    @BuildStep
    public void createAnnotations(OpenshiftConfig config, BuildProducer<KubernetesAnnotationBuildItem> annotations) {
        config.getAnnotations().forEach((k, v) -> annotations.produce((BuildItem)new KubernetesAnnotationBuildItem(k, v, "openshift")));
    }

    @BuildStep
    public void createLabels(OpenshiftConfig config, BuildProducer<KubernetesLabelBuildItem> labels, BuildProducer<ContainerImageLabelBuildItem> imageLabels) {
        config.getLabels().forEach((k, v) -> {
            labels.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "openshift"));
            imageLabels.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
    }

    @BuildStep
    public List<ConfiguratorBuildItem> createConfigurators(ApplicationInfoBuildItem applicationInfo, OpenshiftConfig config, Capabilities capabilities, Optional<ContainerImageInfoBuildItem> image, List<KubernetesPortBuildItem> ports) {
        ArrayList<ConfiguratorBuildItem> result = new ArrayList<ConfiguratorBuildItem>();
        KubernetesCommonHelper.combinePorts(ports, config).entrySet().forEach(e -> result.add(new ConfiguratorBuildItem((Object)new AddPortToOpenshiftConfig((Port)e.getValue()))));
        result.add(new ConfiguratorBuildItem((Object)new ApplyExpositionConfigurator(config.route)));
        if (!(capabilities.isPresent("io.quarkus.container.image.s2i") || capabilities.isPresent("io.quarkus.openshift") || capabilities.isPresent("io.quarkus.container.image.openshift"))) {
            result.add(new ConfiguratorBuildItem((Object)new DisableS2iConfigurator()));
            image.flatMap(ContainerImageInfoBuildItem::getRegistry).ifPresent(r -> result.add(new ConfiguratorBuildItem((Object)new ApplyImageRegistryConfigurator((String)r))));
            image.map(ContainerImageInfoBuildItem::getGroup).ifPresent(g -> result.add(new ConfiguratorBuildItem((Object)new ApplyImageGroupConfigurator((String)g))));
        }
        return result;
    }

    @BuildStep
    public List<DecoratorBuildItem> createDecorators(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, OpenshiftConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, Capabilities capabilities, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, List<KubernetesRoleBuildItem> roles, List<KubernetesRoleBindingBuildItem> roleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, outputTarget, packageConfig);
        result.addAll(KubernetesCommonHelper.createDecorators(project, "openshift", name, config, metricsConfiguration, annotations, labels, command, ports, livenessPath, readinessPath, roles, roleBindings));
        if (config.flavor == OpenshiftConfig.OpenshiftFlavor.v3) {
            result.add(new DecoratorBuildItem((Object)new AddLabelDecorator(name, "app", name, new String[0])));
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromSecretEnvSourceDecorator()));
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromConfigMapEnvSourceDecorator()));
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromSecretKeySelectorDecorator()));
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromConfigMapKeySelectorDecorator()));
        }
        switch (config.deploymentKind) {
            case Deployment: {
                result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentConfigResourceDecorator(name)));
                result.add(new DecoratorBuildItem("openshift", (Object)new AddDeploymentResourceDecorator(name, config)));
                break;
            }
            case StatefulSet: {
                result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentConfigResourceDecorator(name)));
                result.add(new DecoratorBuildItem("openshift", (Object)new AddStatefulSetResourceDecorator(name, config)));
            }
        }
        if (config.getReplicas() != 1) {
            result.add(new DecoratorBuildItem("openshift", (Object)new ApplyReplicasDecorator(name, config.getReplicas().intValue())));
            result.add(new DecoratorBuildItem("openshift", (Object)new io.dekorate.kubernetes.decorator.ApplyReplicasDecorator(name, config.getReplicas().intValue())));
            result.add(new DecoratorBuildItem("openshift", (Object)new ApplyReplicasToStatefulSetDecorator(name, config.getReplicas())));
        }
        image.ifPresent(i -> result.add(new DecoratorBuildItem("openshift", (Object)new ApplyContainerImageDecorator(name, i.getImage()))));
        result.add(new DecoratorBuildItem("openshift", (Object)new AddLabelDecorator(name, "app.openshift.io/runtime", "quarkus", new String[0])));
        Stream.concat(config.convertToBuildItems().stream(), envs.stream().filter(e -> e.getTarget() == null || "openshift".equals(e.getTarget()))).forEach(e -> result.add(new DecoratorBuildItem("openshift", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build()))));
        baseImage.map(BaseImageInfoBuildItem::getImage).ifPresent(builderImage -> {
            String builderImageName = ImageUtil.getName((String)builderImage);
            EditableS2iBuildConfig s2iBuildConfig = ((S2iBuildConfigBuilder)new S2iBuildConfigBuilder().withBuilderImage(builderImage)).build();
            if (!"s2i-java".equals(builderImageName)) {
                result.add(new DecoratorBuildItem("openshift", (Object)new RemoveBuilderImageResourceDecorator("s2i-java")));
            }
            result.add(new DecoratorBuildItem("openshift", (Object)new AddBuilderImageStreamResourceDecorator((S2iBuildConfig)s2iBuildConfig)));
            result.add(new DecoratorBuildItem("openshift", (Object)new ApplyBuilderImageDecorator(name, (String)builderImage)));
        });
        if (!config.addVersionToLabelSelectors) {
            result.add(new DecoratorBuildItem("openshift", (Object)new RemoveLabelDecorator(name, "app.kubernetes.io/version")));
            result.add(new DecoratorBuildItem("openshift", (Object)new RemoveFromSelectorDecorator(name, "app.kubernetes.io/version")));
        }
        result.add(new DecoratorBuildItem("openshift", (Object)new ApplyServiceTypeDecorator(name, config.getServiceType().name())));
        if (config.getServiceType() == ServiceType.NodePort && config.nodePort.isPresent()) {
            result.add(new DecoratorBuildItem("openshift", (Object)new AddNodePortDecorator(name, config.nodePort.getAsInt())));
        }
        Integer port = ports.stream().filter(p -> "http".equals(p.getName())).map(KubernetesPortBuildItem::getPort).findFirst().orElse(8080);
        result.add(new DecoratorBuildItem("openshift", (Object)new ApplyHttpGetActionPortDecorator(name, name, port)));
        if (!(capabilities.isPresent("io.quarkus.container.image.s2i") || capabilities.isPresent("io.quarkus.openshift") || capabilities.isPresent("io.quarkus.container.image.openshift"))) {
            result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentTriggerDecorator()));
            EditableImageConfiguration imageConfiguration = new ImageConfigurationBuilder().build();
            image.ifPresent(arg_0 -> OpenshiftProcessor.lambda$createDecorators$11(result, (ImageConfiguration)imageConfiguration, arg_0));
        }
        return result;
    }

    private static /* synthetic */ void lambda$createDecorators$11(List result, ImageConfiguration imageConfiguration, ContainerImageInfoBuildItem i) {
        String repo = i.getRegistry().map(reg -> reg + "/" + i.getRepository()).orElse(i.getRepository());
        result.add(new DecoratorBuildItem("openshift", (Object)new AddDockerImageStreamResourceDecorator(imageConfiguration, repo)));
    }
}

