/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class RemoveDeploymentConfigResourceDecorator
extends Decorator<KubernetesListBuilder> {
    private String name;

    public RemoveDeploymentConfigResourceDecorator(String name) {
        this.name = name;
    }

    public void visit(KubernetesListBuilder builder) {
        List imageStreams = builder.getItems().stream().filter(d -> d instanceof HasMetadata).map(d -> d).filter(i -> i.getKind().equals("DeploymentConfig") && i.getMetadata().getName().equalsIgnoreCase(this.name)).collect(Collectors.toList());
        builder.removeAllFromItems(imageStreams);
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

