/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.BuildMojo;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public class AbstractImageMojo
extends BuildMojo {
    @Parameter(defaultValue="docker", property="quarkus.container-image.builder")
    Builder builder = Builder.docker;
    @Parameter(property="quarkus.container-image.dry-run")
    boolean dryRun;

    @Override
    protected boolean beforeExecute() throws MojoExecutionException {
        this.systemProperties.put("quarkus.container-image.builder", this.builder.name());
        return super.beforeExecute();
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"Container image configuration:");
            this.systemProperties.entrySet().stream().filter(e -> ((String)e.getKey()).contains("quarkus.container-image")).forEach(e -> this.getLog().info((CharSequence)(" - " + (String)e.getKey() + ": " + (String)e.getValue())));
        } else {
            super.doExecute();
        }
    }

    @Override
    protected List<Dependency> forcedDependencies(LaunchMode mode) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        this.getContainerImageExtension(this.builder).ifPresent(d -> dependencies.add((Dependency)d));
        return dependencies;
    }

    protected Optional<ArtifactDependency> getContainerImageExtension(Builder builder) {
        return this.getExtension("quarkus-container-image-" + builder.name());
    }

    protected Optional<ArtifactDependency> getExtension(String artifactId) {
        return this.mavenProject().getDependencyManagement().getDependencies().stream().filter(d -> "io.quarkus".equals(d.getGroupId()) && artifactId.equals(d.getArtifactId())).map(d -> new ArtifactDependency(d.getGroupId(), d.getArtifactId(), null, "jar", d.getVersion())).findFirst();
    }

    public static enum Builder {
        docker,
        jib,
        buildpack,
        openshift;

    }
}

