/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder;

import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.binder.HttpMetricsCommon;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class HttpRequestMetric {
    static final Logger log = Logger.getLogger(HttpRequestMetric.class);
    public static final String HTTP_REQUEST_PATH = "HTTP_REQUEST_PATH";
    public static final String HTTP_REQUEST_PATH_MATCHED = "HTTP_REQUEST_MATCHED_PATH";
    public static final Pattern VERTX_ROUTE_PARAM = Pattern.compile("^:(.*)$");
    static final ConcurrentHashMap<String, String> templatePath = new ConcurrentHashMap();
    volatile RoutingContext routingContext;
    boolean measure = false;
    String path;
    boolean pathMatched = false;
    Timer.Sample sample;
    Tags tags = Tags.empty();

    public Timer.Sample getSample() {
        return this.sample;
    }

    public void setSample(Timer.Sample sample) {
        this.sample = sample;
    }

    public Tags getTags() {
        return this.tags;
    }

    public void setTags(Tags tags) {
        this.tags = tags;
    }

    public void parseUriPath(Map<Pattern, String> matchPattern, List<Pattern> ignorePatterns, String uri) {
        if (uri == null) {
            return;
        }
        String path = "/" + HttpRequestMetric.extractPath(uri);
        path = HttpMetricsCommon.MULTIPLE_SLASH_PATTERN.matcher(path).replaceAll("/");
        if ((path = HttpMetricsCommon.TRAILING_SLASH_PATTERN.matcher(path).replaceAll("")).isEmpty()) {
            path = "/";
        }
        this.path = path;
        for (Map.Entry<Pattern, String> mp : matchPattern.entrySet()) {
            this.path = mp.getKey().matcher(this.path).replaceAll(mp.getValue());
        }
        this.pathMatched = !path.equals(this.path);
        for (Pattern p : ignorePatterns) {
            if (!p.matcher(this.path).matches()) continue;
            log.debugf("Path %s ignored; matches pattern %s", (Object)uri, (Object)p.pattern());
            return;
        }
        this.measure = true;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isMeasure() {
        return this.measure;
    }

    public boolean isPathMatched() {
        return this.pathMatched;
    }

    private static String extractPath(String uri) {
        int i;
        if (uri.isEmpty()) {
            return uri;
        }
        if (uri.charAt(0) == '/') {
            i = 0;
        } else {
            i = uri.indexOf("://");
            if (i == -1) {
                i = 0;
            } else if ((i = uri.indexOf(47, i + 3)) == -1) {
                return "/";
            }
        }
        int queryStart = uri.indexOf(63, i);
        if (queryStart == -1) {
            queryStart = uri.length();
        }
        return uri.substring(i, queryStart);
    }

    public String getHttpRequestPath() {
        if (this.pathMatched) {
            return this.path;
        }
        if (this.routingContext != null) {
            String rcPath = (String)this.routingContext.get(HTTP_REQUEST_PATH);
            if (rcPath != null) {
                return rcPath;
            }
            String matchedPath = this.routingContext.currentRoute().getPath();
            if (matchedPath != null) {
                if (matchedPath.contains(":")) {
                    matchedPath = templatePath.computeIfAbsent(matchedPath, k -> {
                        CharSequence[] segments = k.split("/");
                        for (int i = 0; i < segments.length; ++i) {
                            segments[i] = VERTX_ROUTE_PARAM.matcher(segments[i]).replaceAll("{$1}");
                        }
                        return String.join((CharSequence)"/", segments);
                    });
                }
                return matchedPath;
            }
        }
        return this.path;
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public void setRoutingContext(RoutingContext routingContext) {
        this.routingContext = routingContext;
    }
}

