/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MeterHolder;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricDescriptor;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetadata;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricType;

interface GaugeAdapter<T>
extends Gauge<T>,
MeterHolder {
    public GaugeAdapter<T> register(MpMetadata var1, MetricDescriptor var2, MeterRegistry var3);

    public static class NumberSupplierGauge<T extends Number>
    implements GaugeAdapter<T> {
        io.micrometer.core.instrument.Gauge gauge;
        final Supplier<T> supplier;

        NumberSupplierGauge(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public GaugeAdapter<T> register(MpMetadata metadata, MetricDescriptor metricInfo, MeterRegistry registry) {
            if (this.gauge == null || metadata.cleanDirtyMetadata()) {
                this.gauge = io.micrometer.core.instrument.Gauge.builder((String)metricInfo.name(), this.supplier).description(metadata.description()).tags((Iterable)metricInfo.tags()).baseUnit(metadata.unit()).strongReference(true).register(registry);
            }
            return this;
        }

        @Override
        public Meter getMeter() {
            return this.gauge;
        }

        public T getValue() {
            return (T)((Number)this.supplier.get());
        }

        @Override
        public MetricType getType() {
            return MetricType.GAUGE;
        }
    }

    public static class DoubleFunctionGauge<S>
    implements GaugeAdapter<Double> {
        io.micrometer.core.instrument.Gauge gauge;
        final S obj;
        final ToDoubleFunction<S> f;

        DoubleFunctionGauge(S obj, ToDoubleFunction<S> f) {
            this.obj = obj;
            this.f = f;
        }

        @Override
        public GaugeAdapter<Double> register(MpMetadata metadata, MetricDescriptor metricInfo, MeterRegistry registry) {
            this.gauge = io.micrometer.core.instrument.Gauge.builder((String)metricInfo.name(), this.obj, this.f).description(metadata.description()).tags((Iterable)metricInfo.tags()).baseUnit(metadata.unit()).strongReference(true).register(registry);
            return this;
        }

        @Override
        public Meter getMeter() {
            return this.gauge;
        }

        public Double getValue() {
            return this.gauge.value();
        }

        @Override
        public MetricType getType() {
            return MetricType.GAUGE;
        }
    }
}

