/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MeterHolder;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricDescriptor;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetadata;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

class TimerAdapter
implements Timer,
SimpleTimer,
MeterHolder {
    final MeterRegistry registry;
    io.micrometer.core.instrument.Timer timer;

    TimerAdapter(MeterRegistry registry) {
        this.registry = registry;
    }

    public TimerAdapter register(MpMetadata metadata, MetricDescriptor descriptor) {
        if (this.timer == null || metadata.cleanDirtyMetadata()) {
            this.timer = io.micrometer.core.instrument.Timer.builder((String)descriptor.name()).description(metadata.description()).tags((Iterable)descriptor.tags()).register(this.registry);
        }
        return this;
    }

    public void update(long l, TimeUnit timeUnit) {
        this.timer.record(l, timeUnit);
    }

    public void update(Duration duration) {
        this.timer.record(duration);
    }

    public <T> T time(Callable<T> callable) throws Exception {
        return (T)this.timer.wrap(callable).call();
    }

    public void time(Runnable runnable) {
        this.timer.wrap(runnable);
    }

    public SampleAdapter time() {
        return new SampleAdapter(this.timer, io.micrometer.core.instrument.Timer.start((MeterRegistry)this.registry));
    }

    public Duration getElapsedTime() {
        throw new UnsupportedOperationException("This operation is not supported when used with micrometer");
    }

    public long getCount() {
        return this.timer.count();
    }

    public double getFifteenMinuteRate() {
        throw new UnsupportedOperationException("This operation is not supported when used with micrometer");
    }

    public double getFiveMinuteRate() {
        throw new UnsupportedOperationException("This operation is not supported when used with micrometer");
    }

    public double getMeanRate() {
        throw new UnsupportedOperationException("This operation is not supported when used with micrometer");
    }

    public double getOneMinuteRate() {
        throw new UnsupportedOperationException("This operation is not supported when used with micrometer");
    }

    public Snapshot getSnapshot() {
        throw new UnsupportedOperationException("This operation is not supported when used with micrometer");
    }

    @Override
    public Meter getMeter() {
        return this.timer;
    }

    public Timer.Sample start() {
        return io.micrometer.core.instrument.Timer.start((MeterRegistry)this.registry);
    }

    public void stop(Timer.Sample sample) {
        sample.stop(this.timer);
    }

    @Override
    public MetricType getType() {
        return MetricType.TIMER;
    }

    class SampleAdapter
    implements Timer.Context,
    SimpleTimer.Context {
        final io.micrometer.core.instrument.Timer timer;
        final Timer.Sample sample;

        SampleAdapter(io.micrometer.core.instrument.Timer timer, Timer.Sample sample) {
            this.sample = sample;
            this.timer = timer;
        }

        public long stop() {
            return this.sample.stop(this.timer);
        }

        public void close() {
            this.sample.stop(this.timer);
        }
    }
}

