/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

public class MapReduceOptions {
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson sort;
    private Bson filter;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private TimeUnit maxTimeUnit;
    private long maxTime;
    private MapReduceAction action;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private boolean bypassDocumentValidation;
    private Collation collation;

    public MapReduceOptions collectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    public MapReduceOptions finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public MapReduceOptions scope(Bson scope) {
        this.scope = scope;
        return this;
    }

    public MapReduceOptions sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    public MapReduceOptions filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    public MapReduceOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MapReduceOptions jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public MapReduceOptions verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public MapReduceOptions maxTime(long maxTime, TimeUnit timeUnit) {
        this.maxTime = maxTime;
        this.maxTimeUnit = timeUnit;
        return this;
    }

    public MapReduceOptions action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    public MapReduceOptions databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public MapReduceOptions sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    public MapReduceOptions nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    public MapReduceOptions bypassDocumentValidation(boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public MapReduceOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public <T> MapReducePublisher<T> apply(MapReducePublisher<T> stream) {
        MapReducePublisher publisher = stream;
        if (this.collectionName != null) {
            publisher = publisher.collectionName(this.collectionName);
        }
        if (this.finalizeFunction != null) {
            publisher = publisher.finalizeFunction(this.finalizeFunction);
        }
        if (this.scope != null) {
            publisher = publisher.scope(this.scope);
        }
        if (this.sort != null) {
            publisher = publisher.sort(this.sort);
        }
        if (this.filter != null) {
            publisher = publisher.filter(this.filter);
        }
        if (this.limit > 0) {
            publisher = publisher.limit(this.limit);
        }
        publisher = publisher.jsMode(this.jsMode);
        publisher = publisher.verbose(this.verbose);
        if (this.maxTime > 0L) {
            publisher = publisher.maxTime(this.maxTime, this.maxTimeUnit);
        }
        if (this.action != null) {
            publisher = publisher.action(this.action);
        }
        if (this.databaseName != null) {
            publisher = publisher.databaseName(this.databaseName);
        }
        publisher = publisher.sharded(this.sharded);
        publisher = publisher.nonAtomic(this.nonAtomic);
        publisher = publisher.bypassDocumentValidation(Boolean.valueOf(this.bypassDocumentValidation));
        if (this.collation != null) {
            publisher = publisher.collation(this.collation);
        }
        return publisher;
    }
}

