/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcEndpointAccessException;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.build.JwtSignatureBuilder;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;

public class OidcCommonUtils {
    public static final Duration CONNECTION_BACKOFF_DURATION = Duration.ofSeconds(2L);
    static final byte AMP = 38;
    static final byte EQ = 61;
    static final String HTTP_SCHEME = "http";
    private static final Logger LOG = Logger.getLogger(OidcCommonUtils.class);

    private OidcCommonUtils() {
    }

    public static void verifyEndpointUrl(String endpointUrl) {
        try {
            URI.create(endpointUrl).toURL();
        }
        catch (Throwable ex) {
            throw new ConfigurationException(String.format("'%s' is invalid", endpointUrl), ex);
        }
    }

    public static void verifyCommonConfiguration(OidcCommonConfig oidcConfig, boolean clientIdOptional, boolean isServerConfig) {
        String configPrefix;
        String string = configPrefix = isServerConfig ? "quarkus.oidc." : "quarkus.oidc-client.";
        if (!clientIdOptional && !oidcConfig.getClientId().isPresent()) {
            throw new ConfigurationException(String.format("'%sclient-id' property must be configured", configPrefix));
        }
        OidcCommonConfig.Credentials creds = oidcConfig.getCredentials();
        if (creds.secret.isPresent() && creds.clientSecret.value.isPresent()) {
            throw new ConfigurationException(String.format("'%1$scredentials.secret' and '%1$scredentials.client-secret' properties are mutually exclusive", configPrefix));
        }
        if ((creds.secret.isPresent() || creds.clientSecret.value.isPresent()) && creds.jwt.secret.isPresent()) {
            throw new ConfigurationException(String.format("Use only '%1$scredentials.secret' or '%1$scredentials.client-secret' or '%1$scredentials.jwt.secret' property", configPrefix));
        }
    }

    public static String prependSlash(String path) {
        return !path.startsWith("/") ? "/" + path : path;
    }

    public static Buffer encodeForm(MultiMap form) {
        Buffer buffer = Buffer.buffer();
        for (Map.Entry entry : form) {
            if (buffer.length() != 0) {
                buffer.appendByte((byte)38);
            }
            buffer.appendString((String)entry.getKey());
            buffer.appendByte((byte)61);
            buffer.appendString(OidcCommonUtils.urlEncode((String)entry.getValue()));
        }
        return buffer;
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setHttpClientOptions(OidcCommonConfig oidcConfig, TlsConfig tlsConfig, HttpClientOptions options) {
        OptionalInt maxPoolSize;
        Optional<ProxyOptions> proxyOpt;
        boolean trustAll;
        boolean bl = oidcConfig.tls.verification.isPresent() ? oidcConfig.tls.verification.get() == OidcCommonConfig.Tls.Verification.NONE : (trustAll = tlsConfig.trustAll);
        if (trustAll) {
            options.setTrustAll(true);
            options.setVerifyHost(false);
        } else if (oidcConfig.tls.trustStoreFile.isPresent()) {
            try {
                byte[] trustStoreData = OidcCommonUtils.getFileContent(oidcConfig.tls.trustStoreFile.get());
                KeyStoreOptions trustStoreOptions = new KeyStoreOptions().setPassword(oidcConfig.tls.getTrustStorePassword().orElse("password")).setAlias((String)oidcConfig.tls.getTrustStoreCertAlias().orElse(null)).setValue(io.vertx.core.buffer.Buffer.buffer((byte[])trustStoreData)).setType(OidcCommonUtils.getKeyStoreType(oidcConfig.tls.trustStoreFileType, oidcConfig.tls.trustStoreFile.get())).setProvider((String)oidcConfig.tls.trustStoreProvider.orElse(null));
                options.setTrustOptions((TrustOptions)trustStoreOptions);
                if (OidcCommonConfig.Tls.Verification.CERTIFICATE_VALIDATION == oidcConfig.tls.verification.orElse(OidcCommonConfig.Tls.Verification.REQUIRED)) {
                    options.setVerifyHost(false);
                }
            }
            catch (IOException ex) {
                throw new ConfigurationException(String.format("OIDC truststore file does not exist or can not be read", oidcConfig.tls.trustStoreFile.get().toString()), (Throwable)ex);
            }
        }
        if (oidcConfig.tls.keyStoreFile.isPresent()) {
            try {
                byte[] keyStoreData = OidcCommonUtils.getFileContent(oidcConfig.tls.keyStoreFile.get());
                KeyStoreOptions keyStoreOptions = new KeyStoreOptions().setAlias((String)oidcConfig.tls.keyStoreKeyAlias.orElse(null)).setAliasPassword((String)oidcConfig.tls.keyStoreKeyPassword.orElse(null)).setValue(io.vertx.core.buffer.Buffer.buffer((byte[])keyStoreData)).setType(OidcCommonUtils.getKeyStoreType(oidcConfig.tls.keyStoreFileType, oidcConfig.tls.keyStoreFile.get())).setProvider((String)oidcConfig.tls.keyStoreProvider.orElse(null));
                if (oidcConfig.tls.keyStorePassword.isPresent()) {
                    keyStoreOptions.setPassword(oidcConfig.tls.keyStorePassword.get());
                }
                options.setKeyCertOptions((KeyCertOptions)keyStoreOptions);
            }
            catch (IOException ex) {
                throw new ConfigurationException(String.format("OIDC keystore file does not exist or can not be read", oidcConfig.tls.keyStoreFile.get().toString()), (Throwable)ex);
            }
        }
        if ((proxyOpt = OidcCommonUtils.toProxyOptions(oidcConfig.getProxy())).isPresent()) {
            options.setProxyOptions(proxyOpt.get());
        }
        if ((maxPoolSize = oidcConfig.maxPoolSize).isPresent()) {
            options.setMaxPoolSize(maxPoolSize.getAsInt());
        }
        options.setConnectTimeout((int)oidcConfig.getConnectionTimeout().toMillis());
    }

    public static String getKeyStoreType(Optional<String> fileType, Path storePath) {
        if (fileType.isPresent()) {
            return fileType.get().toUpperCase();
        }
        String pathName = storePath.toString();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "PKCS12";
        }
        return "JKS";
    }

    public static String getAuthServerUrl(OidcCommonConfig oidcConfig) {
        return OidcCommonUtils.removeLastPathSeparator(oidcConfig.getAuthServerUrl().get());
    }

    private static String removeLastPathSeparator(String value) {
        return value.endsWith("/") ? value.substring(0, value.length() - 1) : value;
    }

    public static String getOidcEndpointUrl(String authServerUrl, Optional<String> endpointPath) {
        if (endpointPath != null && endpointPath.isPresent()) {
            return OidcCommonUtils.isAbsoluteUrl(endpointPath) ? endpointPath.get() : authServerUrl + OidcCommonUtils.prependSlash(endpointPath.get());
        }
        return null;
    }

    public static boolean isAbsoluteUrl(Optional<String> endpointUrl) {
        return endpointUrl.isPresent() && endpointUrl.get().startsWith(HTTP_SCHEME);
    }

    private static long getConnectionDelay(OidcCommonConfig oidcConfig) {
        return oidcConfig.getConnectionDelay().isPresent() ? oidcConfig.getConnectionDelay().get().getSeconds() : 0L;
    }

    public static long getConnectionDelayInMillis(OidcCommonConfig oidcConfig) {
        long connectionRetryCount;
        long connectionDelayInSecs = OidcCommonUtils.getConnectionDelay(oidcConfig);
        long l = connectionRetryCount = connectionDelayInSecs > 1L ? connectionDelayInSecs / 2L : 1L;
        if (connectionRetryCount > 1L) {
            LOG.infof("Connecting to OpenId Connect Provider for up to %d times every 2 seconds", (Object)connectionRetryCount);
        }
        return connectionDelayInSecs * 1000L;
    }

    public static Optional<ProxyOptions> toProxyOptions(OidcCommonConfig.Proxy proxyConfig) {
        if (!proxyConfig.host.isPresent()) {
            return Optional.empty();
        }
        JsonObject jsonOptions = new JsonObject();
        String host = URI.create(proxyConfig.host.get()).getHost();
        if (host == null) {
            host = proxyConfig.host.get();
        }
        jsonOptions.put("host", (Object)host);
        jsonOptions.put("port", (Object)proxyConfig.port);
        if (proxyConfig.username.isPresent()) {
            jsonOptions.put("username", (Object)proxyConfig.username.get());
        }
        if (proxyConfig.password.isPresent()) {
            jsonOptions.put("password", (Object)proxyConfig.password.get());
        }
        return Optional.of(new ProxyOptions(jsonOptions));
    }

    public static String formatConnectionErrorMessage(String authServerUrlString) {
        return String.format("OIDC server is not available at the '%s' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'", authServerUrlString);
    }

    public static boolean isClientSecretBasicAuthRequired(OidcCommonConfig.Credentials creds) {
        return creds.secret.isPresent() || (creds.clientSecret.value.isPresent() || creds.clientSecret.provider.key.isPresent()) && OidcCommonUtils.clientSecretMethod(creds) == OidcCommonConfig.Credentials.Secret.Method.BASIC;
    }

    public static boolean isClientJwtAuthRequired(OidcCommonConfig.Credentials creds) {
        return creds.jwt.secret.isPresent() || creds.jwt.secretProvider.key.isPresent() || creds.jwt.keyFile.isPresent() || creds.jwt.keyStoreFile.isPresent();
    }

    public static boolean isClientSecretPostAuthRequired(OidcCommonConfig.Credentials creds) {
        return (creds.clientSecret.value.isPresent() || creds.clientSecret.provider.key.isPresent()) && OidcCommonUtils.clientSecretMethod(creds) == OidcCommonConfig.Credentials.Secret.Method.POST;
    }

    public static boolean isClientSecretPostJwtAuthRequired(OidcCommonConfig.Credentials creds) {
        return OidcCommonUtils.clientSecretMethod(creds) == OidcCommonConfig.Credentials.Secret.Method.POST_JWT && OidcCommonUtils.isClientJwtAuthRequired(creds);
    }

    public static String clientSecret(OidcCommonConfig.Credentials creds) {
        return creds.secret.orElse(creds.clientSecret.value.orElseGet(OidcCommonUtils.fromCredentialsProvider(creds.clientSecret.provider)));
    }

    public static String jwtSecret(OidcCommonConfig.Credentials creds) {
        return creds.jwt.secret.orElseGet(OidcCommonUtils.fromCredentialsProvider(creds.jwt.secretProvider));
    }

    public static OidcCommonConfig.Credentials.Secret.Method clientSecretMethod(OidcCommonConfig.Credentials creds) {
        return creds.clientSecret.method.orElseGet(() -> OidcCommonConfig.Credentials.Secret.Method.BASIC);
    }

    private static Supplier<? extends String> fromCredentialsProvider(final OidcCommonConfig.Credentials.Provider provider) {
        return new Supplier<String>(){

            @Override
            public String get() {
                String providerName;
                CredentialsProvider credentialsProvider;
                if (provider.key.isPresent() && (credentialsProvider = CredentialsProviderFinder.find((String)(providerName = (String)provider.name.orElse(null)))) != null) {
                    return (String)credentialsProvider.getCredentials(providerName).get(provider.key.get());
                }
                return null;
            }
        };
    }

    public static Key clientJwtKey(OidcCommonConfig.Credentials creds) {
        Key key;
        block8: {
            if (creds.jwt.secret.isPresent() || creds.jwt.secretProvider.key.isPresent()) {
                return KeyUtils.createSecretKeyFromSecret((String)OidcCommonUtils.jwtSecret(creds));
            }
            key = null;
            try {
                if (creds.jwt.getKeyFile().isPresent()) {
                    key = KeyUtils.readSigningKey((String)creds.jwt.getKeyFile().get(), (String)creds.jwt.keyId.orElse(null), (SignatureAlgorithm)OidcCommonUtils.getSignatureAlgorithm(creds, SignatureAlgorithm.RS256));
                    break block8;
                }
                if (!creds.jwt.keyStoreFile.isPresent()) break block8;
                KeyStore ks = KeyStore.getInstance("JKS");
                InputStream is = ResourceUtils.getResourceStream((String)creds.jwt.keyStoreFile.get());
                if (creds.jwt.keyStorePassword.isPresent()) {
                    ks.load(is, creds.jwt.keyStorePassword.get().toCharArray());
                } else {
                    ks.load(is, null);
                }
                if (creds.jwt.keyPassword.isPresent()) {
                    key = ks.getKey(creds.jwt.keyId.get(), creds.jwt.keyPassword.get().toCharArray());
                    break block8;
                }
                throw new ConfigurationException("When using a key store, the `quarkus.oidc-client.credentials.jwt.key-password` property must be set");
            }
            catch (Exception ex) {
                throw new ConfigurationException("Key can not be loaded", (Throwable)ex);
            }
        }
        if (key == null) {
            throw new ConfigurationException("Key is null");
        }
        return key;
    }

    public static String signJwtWithKey(OidcCommonConfig oidcConfig, String tokenRequestUri, Key key) {
        SignatureAlgorithm signatureAlgorithm;
        JwtSignatureBuilder builder = Jwt.claims(OidcCommonUtils.additionalClaims(oidcConfig.credentials.jwt.getClaims())).issuer(oidcConfig.credentials.jwt.issuer.orElse(oidcConfig.clientId.get())).subject(oidcConfig.credentials.jwt.subject.orElse(oidcConfig.clientId.get())).audience(oidcConfig.credentials.jwt.getAudience().isPresent() ? OidcCommonUtils.removeLastPathSeparator(oidcConfig.credentials.jwt.getAudience().get()) : tokenRequestUri).expiresIn((long)oidcConfig.credentials.jwt.lifespan).jws();
        if (oidcConfig.credentials.jwt.getTokenKeyId().isPresent()) {
            builder.keyId(oidcConfig.credentials.jwt.getTokenKeyId().get());
        }
        if ((signatureAlgorithm = OidcCommonUtils.getSignatureAlgorithm(oidcConfig.credentials, null)) != null) {
            builder.algorithm(signatureAlgorithm);
        }
        if (key instanceof SecretKey) {
            return builder.sign((SecretKey)key);
        }
        return builder.sign((PrivateKey)key);
    }

    private static Map<String, Object> additionalClaims(Map<String, String> claims) {
        return claims;
    }

    private static SignatureAlgorithm getSignatureAlgorithm(OidcCommonConfig.Credentials credentials, SignatureAlgorithm defaultAlgorithm) {
        if (credentials.jwt.getSignatureAlgorithm().isPresent()) {
            try {
                return SignatureAlgorithm.fromAlgorithm((String)credentials.jwt.getSignatureAlgorithm().get());
            }
            catch (Exception ex) {
                throw new ConfigurationException("Unsupported signature algorithm");
            }
        }
        return defaultAlgorithm;
    }

    public static void verifyConfigurationId(String defaultId, String configKey, Optional<String> configId) {
        if (configKey.equals(defaultId)) {
            throw new ConfigurationException("configuration id '" + configKey + "' duplicates the default configuration id");
        }
        if (configId.isPresent() && !configKey.equals(configId.get())) {
            throw new ConfigurationException("Configuration has 2 different id values: '" + configKey + "' and '" + configId.get() + "'");
        }
    }

    public static String initClientSecretBasicAuth(OidcCommonConfig oidcConfig) {
        if (OidcCommonUtils.isClientSecretBasicAuthRequired(oidcConfig.credentials)) {
            return OidcCommonUtils.basicSchemeValue(oidcConfig.getClientId().get(), OidcCommonUtils.clientSecret(oidcConfig.credentials));
        }
        return null;
    }

    public static String basicSchemeValue(String name, String secret) {
        return "Basic " + Base64.getEncoder().encodeToString((name + ":" + secret).getBytes(StandardCharsets.UTF_8));
    }

    public static Key initClientJwtKey(OidcCommonConfig oidcConfig) {
        if (OidcCommonUtils.isClientJwtAuthRequired(oidcConfig.credentials)) {
            return OidcCommonUtils.clientJwtKey(oidcConfig.credentials);
        }
        return null;
    }

    public static Predicate<? super Throwable> oidcEndpointNotAvailable() {
        return t -> t instanceof ConnectException || t instanceof OidcEndpointAccessException && ((OidcEndpointAccessException)t).getErrorStatus() == 404;
    }

    public static Uni<JsonObject> discoverMetadata(WebClient client, Map<OidcEndpoint.Type, List<OidcRequestFilter>> filters, OidcRequestContextProperties contextProperties, String authServerUrl, long connectionDelayInMillisecs, io.vertx.mutiny.core.Vertx vertx, boolean blockingDnsLookup) {
        String discoveryUrl = OidcCommonUtils.getDiscoveryUri(authServerUrl);
        HttpRequest request = client.getAbs(discoveryUrl);
        if (!filters.isEmpty()) {
            HashMap<String, Object> newProperties = contextProperties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(contextProperties.getAll());
            newProperties.put(OidcRequestContextProperties.DISCOVERY_ENDPOINT, discoveryUrl);
            OidcRequestContextProperties requestProps = new OidcRequestContextProperties(newProperties);
            for (OidcRequestFilter filter : OidcCommonUtils.getMatchingOidcRequestFilters(filters, OidcEndpoint.Type.DISCOVERY)) {
                filter.filter((HttpRequest<Buffer>)request, null, requestProps);
            }
        }
        return OidcCommonUtils.sendRequest(vertx, (HttpRequest<Buffer>)request, blockingDnsLookup).onItem().transform(resp -> {
            if (resp.statusCode() == 200) {
                return resp.bodyAsJsonObject();
            }
            String errorMessage = resp.bodyAsString();
            if (errorMessage != null && !errorMessage.isEmpty()) {
                LOG.warnf("Discovery request %s has failed, status code: %d, error message: %s", (Object)discoveryUrl, (Object)resp.statusCode(), (Object)errorMessage);
            } else {
                LOG.warnf("Discovery request %s has failed, status code: %d", (Object)discoveryUrl, (Object)resp.statusCode());
            }
            throw new OidcEndpointAccessException(resp.statusCode());
        }).onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(CONNECTION_BACKOFF_DURATION, CONNECTION_BACKOFF_DURATION).expireIn(connectionDelayInMillisecs).onFailure().transform(t -> {
            LOG.warn((Object)"OIDC Server is not available:", t.getCause() != null ? t.getCause() : t);
            return new RuntimeException("OIDC Server is not available");
        });
    }

    public static String getDiscoveryUri(String authServerUrl) {
        return authServerUrl + "/.well-known/openid-configuration";
    }

    private static byte[] getFileContent(Path path) throws IOException {
        byte[] data;
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)path));
        if (resource != null) {
            try (InputStream is = resource;){
                data = OidcCommonUtils.doRead(is);
            }
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            data = OidcCommonUtils.doRead(is);
        }
        return data;
    }

    private static byte[] doRead(InputStream is) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((r = is.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }

    public static Map<OidcEndpoint.Type, List<OidcRequestFilter>> getOidcRequestFilters() {
        ArcContainer container = Arc.container();
        if (container != null) {
            HashMap<OidcEndpoint.Type, List<OidcRequestFilter>> map = new HashMap<OidcEndpoint.Type, List<OidcRequestFilter>>();
            for (OidcRequestFilter filter : container.listAll(OidcRequestFilter.class, new Annotation[0]).stream().map(handle -> (OidcRequestFilter)handle.get()).collect(Collectors.toList())) {
                OidcEndpoint endpoint = ((OidcRequestFilter)ClientProxy.unwrap((Object)filter)).getClass().getAnnotation(OidcEndpoint.class);
                if (endpoint != null) {
                    for (OidcEndpoint.Type type : endpoint.value()) {
                        map.computeIfAbsent(type, k -> new ArrayList()).add(filter);
                    }
                    continue;
                }
                map.computeIfAbsent(OidcEndpoint.Type.ALL, k -> new ArrayList()).add(filter);
            }
            return map;
        }
        return Map.of();
    }

    public static List<OidcRequestFilter> getMatchingOidcRequestFilters(Map<OidcEndpoint.Type, List<OidcRequestFilter>> filters, OidcEndpoint.Type type) {
        List<OidcRequestFilter> typeSpecific = filters.get((Object)type);
        List<OidcRequestFilter> all = filters.get((Object)OidcEndpoint.Type.ALL);
        if (typeSpecific == null && all == null) {
            return List.of();
        }
        if (typeSpecific != null && all == null) {
            return typeSpecific;
        }
        if (typeSpecific == null && all != null) {
            return all;
        }
        ArrayList<OidcRequestFilter> combined = new ArrayList<OidcRequestFilter>(typeSpecific.size() + all.size());
        combined.addAll(typeSpecific);
        combined.addAll(all);
        return combined;
    }

    public static Uni<HttpResponse<Buffer>> sendRequest(Vertx vertx, HttpRequest<Buffer> request, boolean blockingDnsLookup) {
        if (blockingDnsLookup) {
            return OidcCommonUtils.sendRequest(new io.vertx.mutiny.core.Vertx(vertx), request, true);
        }
        return request.send();
    }

    public static Uni<HttpResponse<Buffer>> sendRequest(io.vertx.mutiny.core.Vertx vertx, final HttpRequest<Buffer> request, boolean blockingDnsLookup) {
        if (blockingDnsLookup) {
            return vertx.executeBlocking((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        InetAddress.getByName(request.host());
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            }).flatMap((Function)new Function<Void, Uni<? extends HttpResponse<Buffer>>>(){

                @Override
                public Uni<? extends HttpResponse<Buffer>> apply(Void unused) {
                    return request.send();
                }
            });
        }
        return request.send();
    }
}

