/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TenantConfigResolver;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTenantConfigResolver {
    private static final Logger LOG = Logger.getLogger(DefaultTenantConfigResolver.class);
    private static final String CURRENT_TENANT_CONFIG = "io.quarkus.oidc.current.tenant.config";
    @Inject
    Instance<TenantResolver> tenantResolver;
    @Inject
    Instance<TenantConfigResolver> tenantConfigResolver;
    private final Map<String, TenantConfigContext> dynamicTenantsConfig = new ConcurrentHashMap<String, TenantConfigContext>();
    @Inject
    TenantConfigBean tenantConfigBean;
    @Inject
    Event<SecurityEvent> securityEvent;
    private volatile boolean securityEventObserved;

    @PostConstruct
    public void verifyResolvers() {
        if (this.tenantConfigResolver.isResolvable() && this.tenantConfigResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantConfigResolver.class + " beans registered");
        }
        if (this.tenantResolver.isAmbiguous()) {
            throw new IllegalStateException("Multiple " + TenantResolver.class + " beans registered");
        }
    }

    TenantConfigContext resolve(RoutingContext context, boolean create) {
        TenantConfigContext config = this.getTenantConfigFromConfigResolver(context, create);
        if (config == null) {
            config = this.getTenantConfigFromTenantResolver(context);
        } else if (create && config.auth == null && !config.oidcConfig.getPublicKey().isPresent()) {
            throw new OIDCException("OIDC IDP connection must be available");
        }
        return config;
    }

    private TenantConfigContext getTenantConfigFromTenantResolver(RoutingContext context) {
        TenantConfigContext configContext;
        String tenantId = null;
        if (this.tenantResolver.isResolvable()) {
            tenantId = ((TenantResolver)this.tenantResolver.get()).resolve(context);
        }
        TenantConfigContext tenantConfigContext = configContext = tenantId != null ? this.tenantConfigBean.getStaticTenantsConfig().get(tenantId) : null;
        if (configContext == null) {
            if (tenantId != null && !tenantId.isEmpty()) {
                LOG.debugf("No configuration with a tenant id '%s' has been found, using the default configuration", new Object[0]);
            }
            configContext = this.tenantConfigBean.getDefaultTenant();
        }
        return configContext;
    }

    boolean isBlocking(RoutingContext context) {
        TenantConfigContext resolver = this.resolve(context, false);
        return resolver != null && (resolver.auth == null || resolver.oidcConfig.token.refreshExpired || resolver.oidcConfig.authentication.userInfoRequired);
    }

    boolean isSecurityEventObserved() {
        return this.securityEventObserved;
    }

    void setSecurityEventObserved(boolean securityEventObserved) {
        this.securityEventObserved = securityEventObserved;
    }

    Event<SecurityEvent> getSecurityEvent() {
        return this.securityEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TenantConfigContext getTenantConfigFromConfigResolver(RoutingContext context, boolean create) {
        if (this.tenantConfigResolver.isResolvable()) {
            OidcTenantConfig tenantConfig;
            if (context.get(CURRENT_TENANT_CONFIG) != null) {
                tenantConfig = (OidcTenantConfig)context.get(CURRENT_TENANT_CONFIG);
            } else {
                tenantConfig = ((TenantConfigResolver)this.tenantConfigResolver.get()).resolve(context);
                if (tenantConfig != null) {
                    context.put(CURRENT_TENANT_CONFIG, (Object)tenantConfig);
                }
            }
            if (tenantConfig != null) {
                String tenantId = tenantConfig.getTenantId().orElseThrow(() -> new OIDCException("Tenant configuration must have tenant id"));
                TenantConfigContext tenantContext = this.dynamicTenantsConfig.get(tenantId);
                if (tenantContext == null) {
                    if (create) {
                        Map<String, TenantConfigContext> map = this.dynamicTenantsConfig;
                        synchronized (map) {
                            tenantContext = this.dynamicTenantsConfig.computeIfAbsent(tenantId, clientId -> this.tenantConfigBean.getTenantConfigContextFactory().apply(tenantConfig));
                        }
                    } else {
                        tenantContext = new TenantConfigContext(null, tenantConfig);
                    }
                }
                return tenantContext;
            }
        }
        return null;
    }
}

