/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TenantFeature;
import io.quarkus.oidc.TokenCustomizer;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class TenantFeatureFinder {
    private TenantFeatureFinder() {
    }

    public static TokenCustomizer find(OidcTenantConfig oidcConfig) {
        if (oidcConfig == null) {
            return null;
        }
        ArcContainer container = Arc.container();
        if (container != null) {
            String customizerName = oidcConfig.token.customizerName.orElse(null);
            if (customizerName != null && !customizerName.isEmpty()) {
                InstanceHandle tokenCustomizer = container.instance(customizerName);
                if (tokenCustomizer.isAvailable()) {
                    return (TokenCustomizer)tokenCustomizer.get();
                }
                throw new OIDCException("Unable to find TokenCustomizer " + customizerName);
            }
            if (oidcConfig.tenantId.isPresent()) {
                return (TokenCustomizer)container.instance(TokenCustomizer.class, new Annotation[]{TenantFeature.TenantFeatureLiteral.of(oidcConfig.tenantId.get())}).get();
            }
        }
        return null;
    }

    public static <T> List<T> find(OidcTenantConfig oidcTenantConfig, Class<T> tenantFeatureClass) {
        if (oidcTenantConfig != null && oidcTenantConfig.tenantId.isPresent()) {
            ArrayList<Object> tenantsValidators = new ArrayList<Object>();
            for (InstanceHandle instance : Arc.container().listAll(tenantFeatureClass, new Annotation[]{Default.Literal.INSTANCE})) {
                if (!instance.isAvailable()) continue;
                tenantsValidators.add(instance.get());
            }
            for (InstanceHandle instance : Arc.container().listAll(tenantFeatureClass, new Annotation[]{TenantFeature.TenantFeatureLiteral.of(oidcTenantConfig.tenantId.get())})) {
                if (!instance.isAvailable()) continue;
                tenantsValidators.add(instance.get());
            }
            if (!tenantsValidators.isEmpty()) {
                return List.copyOf(tenantsValidators);
            }
        }
        return List.of();
    }
}

