/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.dev;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.opentelemetry.deployment.OpenTelemetryEnabled;
import io.quarkus.opentelemetry.runtime.dev.OpenTelemetryDevServicesConfigBuilder;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;

public class DevServicesOpenTelemetryProcessor {
    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={OpenTelemetryEnabled.class, GlobalDevServicesConfig.Enabled.class})
    void devServicesDatasources(Optional<DevServicesDatasourceResultBuildItem> devServicesDatasources, BuildProducer<GeneratedResourceBuildItem> generatedResource, BuildProducer<RunTimeConfigBuilderBuildItem> runtimeConfigBuilder) throws Exception {
        if (devServicesDatasources.isPresent()) {
            Map namedDatasources;
            Properties properties = new Properties();
            DevServicesDatasourceResultBuildItem.DbResult defaultDatasource = devServicesDatasources.get().getDefaultDatasource();
            if (defaultDatasource != null) {
                properties.putAll((Map<?, ?>)defaultDatasource.getConfigProperties());
            }
            if ((namedDatasources = devServicesDatasources.get().getNamedDatasources()) != null) {
                for (DevServicesDatasourceResultBuildItem.DbResult dbResult : namedDatasources.values()) {
                    if (dbResult == null) continue;
                    properties.putAll((Map<?, ?>)dbResult.getConfigProperties());
                }
            }
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.endsWith(".url") || !value.startsWith("jdbc:")) continue;
                String driverKey = key.substring(0, key.length() - 4) + ".driver";
                ConfigValue driverValue = ConfigProvider.getConfig().getConfigValue(driverKey);
                if (driverValue.getValue() == null || !driverValue.getValue().equals("io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver")) continue;
                properties.put(key, value.replaceFirst("jdbc:", "jdbc:otel:"));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            properties.store(out, null);
            generatedResource.produce((BuildItem)new GeneratedResourceBuildItem("opentelemetry-devservices-config.properties", out.toByteArray()));
            runtimeConfigBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(OpenTelemetryDevServicesConfigBuilder.class.getName()));
        }
    }
}

