/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.vertx.core.Vertx;
import org.jboss.logging.Logger;

public enum QuarkusContextStorage implements ContextStorage
{
    INSTANCE;

    private static final Logger log;
    public static final String ACTIVE_CONTEXT;
    static Vertx vertx;

    public Scope attach(Context toAttach) {
        return this.attach(this.getVertxContext(), toAttach);
    }

    public Scope attach(io.vertx.core.Context vertxContext, Context toAttach) {
        if (toAttach == null) {
            return Scope.noop();
        }
        Context beforeAttach = this.getContext(vertxContext);
        if (toAttach == beforeAttach) {
            return Scope.noop();
        }
        if (vertxContext != null) {
            vertxContext.putLocal(ACTIVE_CONTEXT, (Object)toAttach);
            return () -> {
                if (this.getContext(vertxContext) != toAttach) {
                    log.warn((Object)"Context in storage not the expected context, Scope.close was not called correctly");
                }
                if (beforeAttach == null) {
                    vertxContext.removeLocal(ACTIVE_CONTEXT);
                } else {
                    vertxContext.putLocal(ACTIVE_CONTEXT, (Object)beforeAttach);
                }
            };
        }
        return Scope.noop();
    }

    public Context current() {
        return this.getContext(this.getVertxContext());
    }

    private Context getContext(io.vertx.core.Context vertxContext) {
        return vertxContext != null ? (Context)vertxContext.getLocal(ACTIVE_CONTEXT) : null;
    }

    private io.vertx.core.Context getVertxContext() {
        return vertx.getOrCreateContext();
    }

    static {
        log = Logger.getLogger(QuarkusContextStorage.class);
        ACTIVE_CONTEXT = QuarkusContextStorage.class.getName() + ".activeContext";
    }
}

