/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.vertx;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.tracing.vertx.VertxUtil;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.core.tracing.TracingPolicy;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.enterprise.inject.spi.CDI;

public class VertxTracingAdapter
extends TracingOptions
implements VertxTracer<Span, Span>,
VertxTracerFactory {
    private static final String RECEIVE_SCOPE_KEY = VertxTracingAdapter.class.getName() + ".scope.receive";
    private static final String SEND_SCOPE_KEY = VertxTracingAdapter.class.getName() + ".scope.send";
    private static TextMapPropagator TEXT_MAP_PROPAGATOR;
    private Tracer tracer;
    public static final TextMapGetter<Iterable<Map.Entry<String, String>>> GETTER;
    public static final TextMapSetter<BiConsumer<String, String>> SETTER;

    public void init() {
        this.tracer = (Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get();
        TEXT_MAP_PROPAGATOR = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
    }

    public VertxTracerFactory getFactory() {
        return this;
    }

    public VertxTracer<Span, Span> tracer(TracingOptions options) {
        return this;
    }

    public <R> Span receiveRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        Context openTelemetryContext = (Context)context.getLocal(QuarkusContextStorage.ACTIVE_CONTEXT);
        if (openTelemetryContext == null) {
            openTelemetryContext = Context.root();
        }
        openTelemetryContext = TEXT_MAP_PROPAGATOR.extract(openTelemetryContext, headers, GETTER);
        Span currentSpan = this.tracer.spanBuilder(this.operationName(request, operation)).setParent(openTelemetryContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.SERVER : SpanKind.CONSUMER).startSpan();
        if (request instanceof HttpServerRequest) {
            HttpServerRequest httpServerRequest = (HttpServerRequest)request;
            currentSpan.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)VertxTracingAdapter.convertHttpVersion(httpServerRequest.version()));
            currentSpan.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)operation);
            currentSpan.setAttribute(SemanticAttributes.HTTP_TARGET, (Object)httpServerRequest.path());
            currentSpan.setAttribute(SemanticAttributes.HTTP_SCHEME, (Object)httpServerRequest.scheme());
            currentSpan.setAttribute(SemanticAttributes.HTTP_HOST, (Object)httpServerRequest.host());
            currentSpan.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, (Object)VertxUtil.extractClientIP(httpServerRequest));
            currentSpan.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)httpServerRequest.getHeader(HttpHeaders.USER_AGENT));
            String contentLength = httpServerRequest.getHeader(HttpHeaders.CONTENT_LENGTH);
            if (contentLength != null && contentLength.length() > 0 && Long.parseLong(contentLength) > 0L) {
                currentSpan.setAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)Long.valueOf(contentLength));
            } else {
                currentSpan.setAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)httpServerRequest.bytesRead());
            }
        }
        openTelemetryContext = openTelemetryContext.with((ImplicitContextKeyed)currentSpan);
        context.putLocal(RECEIVE_SCOPE_KEY, (Object)QuarkusContextStorage.INSTANCE.attach(context, openTelemetryContext));
        return currentSpan;
    }

    private <R> String operationName(R request, String operationName) {
        if (request instanceof HttpServerRequest) {
            String uri = ((HttpServerRequest)request).uri();
            if (uri.length() > 1) {
                return uri.substring(1);
            }
            return "HTTP " + operationName;
        }
        return operationName;
    }

    public <R> void sendResponse(io.vertx.core.Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span == null) {
            return;
        }
        if (failure != null) {
            span.setStatus(StatusCode.ERROR);
            span.recordException(failure);
        }
        if (response != null && response instanceof HttpServerResponse) {
            HttpServerResponse httpServerResponse = (HttpServerResponse)response;
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, httpServerResponse.getStatusCode());
            String pathTemplate = (String)context.getLocal("UrlPathTemplate");
            if (pathTemplate != null && pathTemplate.length() > 1) {
                span.updateName(pathTemplate.substring(1));
                span.setAttribute(SemanticAttributes.HTTP_ROUTE, (Object)pathTemplate);
            }
        }
        span.end();
        Scope spanScope = (Scope)context.getLocal(RECEIVE_SCOPE_KEY);
        if (spanScope != null) {
            spanScope.close();
            context.removeLocal(RECEIVE_SCOPE_KEY);
        }
    }

    public <R> Span sendRequest(io.vertx.core.Context context, io.vertx.core.spi.tracing.SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        HttpRequestHead requestHead;
        Context openTelemetryContext = (Context)context.getLocal(QuarkusContextStorage.ACTIVE_CONTEXT);
        if (openTelemetryContext == null) {
            openTelemetryContext = Context.root();
        }
        if (request instanceof HttpRequestHead && (requestHead = (HttpRequestHead)request).headers().contains("traceparent")) {
            return null;
        }
        Span outgoingSpan = this.tracer.spanBuilder(this.operationName(request, operation)).setParent(openTelemetryContext).setSpanKind(io.vertx.core.spi.tracing.SpanKind.RPC.equals((Object)kind) ? SpanKind.CLIENT : SpanKind.PRODUCER).startSpan();
        if (request instanceof HttpServerRequest) {
            HttpServerRequest httpServerRequest = (HttpServerRequest)request;
            outgoingSpan.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)httpServerRequest.method().name());
            outgoingSpan.setAttribute(SemanticAttributes.HTTP_URL, (Object)httpServerRequest.uri());
        }
        openTelemetryContext = openTelemetryContext.with((ImplicitContextKeyed)outgoingSpan);
        TEXT_MAP_PROPAGATOR.inject(openTelemetryContext, headers, SETTER);
        context.putLocal(SEND_SCOPE_KEY, (Object)QuarkusContextStorage.INSTANCE.attach(context, openTelemetryContext));
        return outgoingSpan;
    }

    public <R> void receiveResponse(io.vertx.core.Context context, R response, Span span, Throwable failure, TagExtractor<R> tagExtractor) {
        if (span == null) {
            return;
        }
        if (failure != null) {
            span.recordException(failure);
        }
        if (response != null && response instanceof HttpServerResponse) {
            HttpServerResponse httpServerResponse = (HttpServerResponse)response;
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, httpServerResponse.getStatusCode());
        }
        span.end();
        Scope spanScope = (Scope)context.getLocal(SEND_SCOPE_KEY);
        if (spanScope != null) {
            spanScope.close();
            context.removeLocal(SEND_SCOPE_KEY);
        }
    }

    private static String convertHttpVersion(HttpVersion version) {
        switch (version) {
            case HTTP_1_0: {
                return "1.0";
            }
            case HTTP_1_1: {
                return "1.1";
            }
            case HTTP_2: {
                return "2.0";
            }
        }
        return "";
    }

    static {
        GETTER = new TextMapGetter<Iterable<Map.Entry<String, String>>>(){

            public Iterable<String> keys(Iterable<Map.Entry<String, String>> carrier) {
                HashSet<String> keys = new HashSet<String>();
                for (Map.Entry<String, String> entry : carrier) {
                    keys.add(entry.getKey());
                }
                return keys;
            }

            public String get(Iterable<Map.Entry<String, String>> carrier, String key) {
                if (carrier == null) {
                    return null;
                }
                for (Map.Entry<String, String> entry : carrier) {
                    if (!entry.getKey().equalsIgnoreCase(key)) continue;
                    return entry.getValue();
                }
                return null;
            }
        };
        SETTER = new TextMapSetter<BiConsumer<String, String>>(){

            public void set(BiConsumer<String, String> carrier, String key, String value) {
                if (carrier == null) {
                    return;
                }
                carrier.accept(key, value);
            }
        };
    }
}

