/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class DelayedAttributes
implements Attributes {
    private static final Logger log = Logger.getLogger(DelayedAttributes.class);
    private boolean warningLogged = false;
    private Attributes delegate;

    public void setAttributesDelegate(Attributes delegate) {
        this.delegate = delegate;
    }

    public <T> T get(AttributeKey<T> attributeKey) {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return null;
        }
        return (T)this.delegate.get(attributeKey);
    }

    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> biConsumer) {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return;
        }
        this.delegate.forEach(biConsumer);
    }

    public int size() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return 0;
        }
        return this.delegate.size();
    }

    public boolean isEmpty() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return true;
        }
        return this.delegate.isEmpty();
    }

    public Map<AttributeKey<?>, Object> asMap() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return Collections.emptyMap();
        }
        return this.delegate.asMap();
    }

    public AttributesBuilder toBuilder() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return Attributes.builder();
        }
        return this.delegate.toBuilder();
    }

    private void logDelegateNotFound() {
        if (!this.warningLogged) {
            log.warn((Object)"No Attributes delegate specified, no action taken.");
            this.warningLogged = true;
        }
    }
}

