/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.vertx;

import io.netty.handler.codec.http.HttpHeaders;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.tracing.vertx.VertxUtil;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class OpenTelemetryVertxTracer
implements VertxTracer<SpanOperation, SpanOperation> {
    private final Instrumenter<HttpRequest, HttpResponse> serverInstrumenter;
    private final Instrumenter<HttpRequest, HttpResponse> clientInstrumenter;

    public OpenTelemetryVertxTracer(OpenTelemetry openTelemetry) {
        ServerAttributesExtractor serverAttributesExtractor = new ServerAttributesExtractor();
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", ServerSpanNameExtractor.create(serverAttributesExtractor));
        this.serverInstrumenter = serverBuilder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesExtractor)serverAttributesExtractor)).addAttributesExtractor((AttributesExtractor)serverAttributesExtractor).addAttributesExtractor((AttributesExtractor)new AdditionalServerAttributesExtractor()).newServerInstrumenter((TextMapGetter)new HttpRequestTextMapGetter());
        ClientAttributesExtractor clientAttributesExtractor = new ClientAttributesExtractor();
        InstrumenterBuilder clientBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesExtractor)clientAttributesExtractor));
        this.clientInstrumenter = clientBuilder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesExtractor)serverAttributesExtractor)).addAttributesExtractor((AttributesExtractor)clientAttributesExtractor).newClientInstrumenter((TextMapSetter)new HttpRequestTextMapSetter());
    }

    public <R> SpanOperation receiveRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        if (!(request instanceof HttpRequest)) {
            return null;
        }
        Context parentContext = QuarkusContextStorage.getContext(context);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (this.serverInstrumenter.shouldStart(parentContext, (Object)((HttpRequest)request))) {
            Context spanContext = this.serverInstrumenter.start(parentContext, (Object)((HttpRequest)request));
            Scope scope = QuarkusContextStorage.INSTANCE.attach(context, spanContext);
            return SpanOperation.span(context, (HttpRequest)request, spanContext, scope);
        }
        return null;
    }

    public <R> void sendResponse(io.vertx.core.Context context, R response, SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        if (spanOperation == null) {
            return;
        }
        if (!(response instanceof HttpResponse)) {
            return;
        }
        Scope scope = spanOperation.getScope();
        if (scope == null) {
            return;
        }
        SpanRequest httpRequest = SpanRequest.request(spanOperation);
        HttpResponse httpResponse = (HttpResponse)response;
        try (Scope scope2 = scope;){
            this.serverInstrumenter.end(spanOperation.getSpanContext(), (Object)httpRequest, (Object)httpResponse, failure);
        }
    }

    public <R> SpanOperation sendRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        if (!(request instanceof HttpRequest)) {
            return null;
        }
        Context parentContext = QuarkusContextStorage.getContext(context);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (this.clientInstrumenter.shouldStart(parentContext, (Object)((HttpRequest)request))) {
            Context spanContext = this.clientInstrumenter.start(parentContext, (Object)WriteHeadersHttpRequest.request((HttpRequest)request, headers));
            io.vertx.core.Context duplicatedContext = VertxContext.getOrCreateDuplicatedContext((io.vertx.core.Context)context);
            VertxContextSafetyToggle.setContextSafe((io.vertx.core.Context)duplicatedContext, (boolean)true);
            Scope scope = QuarkusContextStorage.INSTANCE.attach(duplicatedContext, spanContext);
            return SpanOperation.span(duplicatedContext, (HttpRequest)request, spanContext, scope);
        }
        return null;
    }

    public <R> void receiveResponse(io.vertx.core.Context context, R response, SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        if (spanOperation == null) {
            return;
        }
        if (!(response instanceof HttpResponse)) {
            return;
        }
        Scope scope = spanOperation.getScope();
        if (scope == null) {
            return;
        }
        SpanRequest httpRequest = SpanRequest.request(spanOperation);
        HttpResponse httpResponse = (HttpResponse)response;
        try (Scope scope2 = scope;){
            this.clientInstrumenter.end(spanOperation.getSpanContext(), (Object)httpRequest, (Object)httpResponse, failure);
        }
    }

    private static class ClientAttributesExtractor
    extends HttpClientAttributesExtractor<HttpRequest, HttpResponse> {
        private ClientAttributesExtractor() {
        }

        protected String url(HttpRequest request) {
            return request.absoluteURI();
        }

        protected String flavor(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected String method(HttpRequest request) {
            return request.method().name();
        }

        protected List<String> requestHeader(HttpRequest request, String name) {
            return request.headers().getAll(name);
        }

        protected Long requestContentLength(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected Long requestContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected Integer statusCode(HttpRequest request, HttpResponse response) {
            return response.statusCode();
        }

        protected Long responseContentLength(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected Long responseContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected List<String> responseHeader(HttpRequest request, HttpResponse response, String name) {
            return response.headers().getAll(name);
        }
    }

    static class WriteHeadersHttpRequest
    implements HttpRequest {
        private final HttpRequest httpRequest;
        private final BiConsumer<String, String> headers;

        WriteHeadersHttpRequest(HttpRequest httpRequest, BiConsumer<String, String> headers) {
            this.httpRequest = httpRequest;
            this.headers = headers;
        }

        public int id() {
            return this.httpRequest.id();
        }

        public String uri() {
            return this.httpRequest.uri();
        }

        public String absoluteURI() {
            return this.httpRequest.absoluteURI();
        }

        public HttpMethod method() {
            return this.httpRequest.method();
        }

        public MultiMap headers() {
            HeadersAdaptor headers = new HeadersAdaptor((HttpHeaders)new HeadersMultiMap()){

                public MultiMap set(String name, String value) {
                    MultiMap result = super.set(name, value);
                    headers.accept(name, value);
                    return result;
                }
            };
            return headers.addAll(this.httpRequest.headers());
        }

        public SocketAddress remoteAddress() {
            return this.httpRequest.remoteAddress();
        }

        static WriteHeadersHttpRequest request(HttpRequest httpRequest, BiConsumer<String, String> headers) {
            return new WriteHeadersHttpRequest(httpRequest, headers);
        }
    }

    private static class HttpRequestTextMapSetter
    implements TextMapSetter<HttpRequest> {
        private HttpRequestTextMapSetter() {
        }

        public void set(HttpRequest carrier, String key, String value) {
            if (carrier != null) {
                carrier.headers().set(key, value);
            }
        }
    }

    private static class AdditionalServerAttributesExtractor
    implements AttributesExtractor<HttpRequest, HttpResponse> {
        private AdditionalServerAttributesExtractor() {
        }

        public void onStart(AttributesBuilder attributes, HttpRequest httpRequest) {
            if (httpRequest instanceof HttpServerRequest) {
                this.set(attributes, SemanticAttributes.HTTP_CLIENT_IP, VertxUtil.extractClientIP((HttpServerRequest)httpRequest));
            }
        }

        public void onEnd(AttributesBuilder attributes, HttpRequest httpRequest, HttpResponse httpResponse, Throwable error) {
            if (httpRequest instanceof SpanRequest) {
                SpanRequest spanRequest = (SpanRequest)httpRequest;
                String route = (String)spanRequest.getSpanOperation().getContext().getLocal((Object)"UrlPathTemplate");
                if (route == null) {
                    route = (String)spanRequest.getSpanOperation().getContext().getLocal((Object)"VertxRoute");
                }
                if (route != null && route.length() > 1) {
                    this.set(attributes, SemanticAttributes.HTTP_ROUTE, route);
                    Span span = Span.fromContext((Context)spanRequest.getSpanOperation().getSpanContext());
                    span.updateName(route.substring(1));
                }
            }
        }
    }

    private static class ServerAttributesExtractor
    extends HttpServerAttributesExtractor<HttpRequest, HttpResponse> {
        private ServerAttributesExtractor() {
        }

        protected String flavor(HttpRequest request) {
            if (request instanceof HttpServerRequest) {
                HttpServerRequest serverRequest = (HttpServerRequest)request;
                switch (serverRequest.version()) {
                    case HTTP_1_0: {
                        return "1.0";
                    }
                    case HTTP_1_1: {
                        return "1.1";
                    }
                    case HTTP_2: {
                        return "2.0";
                    }
                }
                return null;
            }
            return null;
        }

        protected String target(HttpRequest request) {
            return request.uri();
        }

        protected String route(HttpRequest request) {
            return request.uri().length() > 1 ? request.uri() : null;
        }

        protected String scheme(HttpRequest request) {
            if (request instanceof HttpServerRequest) {
                return ((HttpServerRequest)request).scheme();
            }
            return null;
        }

        protected String serverName(HttpRequest request, HttpResponse response) {
            return request.remoteAddress().hostName();
        }

        protected String method(HttpRequest request) {
            return request.method().name();
        }

        protected List<String> requestHeader(HttpRequest request, String name) {
            return request.headers().getAll(name);
        }

        protected Long requestContentLength(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected Long requestContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected Integer statusCode(HttpRequest request, HttpResponse response) {
            return response.statusCode();
        }

        protected Long responseContentLength(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected Long responseContentLengthUncompressed(HttpRequest request, HttpResponse response) {
            return null;
        }

        protected List<String> responseHeader(HttpRequest request, HttpResponse response, String name) {
            return response.headers().getAll(name);
        }
    }

    private static class ServerSpanNameExtractor
    implements SpanNameExtractor<HttpRequest> {
        private final HttpServerAttributesExtractor<HttpRequest, HttpResponse> serverAttributesExtractor;

        private ServerSpanNameExtractor(HttpServerAttributesExtractor<HttpRequest, HttpResponse> serverAttributesExtractor) {
            this.serverAttributesExtractor = serverAttributesExtractor;
        }

        public String extract(HttpRequest httpRequest) {
            if (httpRequest instanceof HttpServerRequest) {
                String path = URI.create(httpRequest.uri()).getPath();
                if (path != null && path.length() > 1) {
                    return path.substring(1);
                }
                return "HTTP " + httpRequest.method();
            }
            return null;
        }

        static SpanNameExtractor<HttpRequest> create(HttpServerAttributesExtractor<HttpRequest, HttpResponse> serverAttributesExtractor) {
            return new ServerSpanNameExtractor(serverAttributesExtractor);
        }
    }

    private static class HttpRequestTextMapGetter
    implements TextMapGetter<HttpRequest> {
        private HttpRequestTextMapGetter() {
        }

        public Iterable<String> keys(HttpRequest carrier) {
            return carrier.headers().names();
        }

        public String get(HttpRequest carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return carrier.headers().get(key);
        }
    }

    static class SpanRequest
    implements HttpRequest {
        private final SpanOperation spanOperation;

        SpanRequest(SpanOperation spanOperation) {
            this.spanOperation = spanOperation;
        }

        public SpanOperation getSpanOperation() {
            return this.spanOperation;
        }

        public int id() {
            return this.spanOperation.getRequest().id();
        }

        public String uri() {
            return this.spanOperation.getRequest().uri();
        }

        public String absoluteURI() {
            return this.spanOperation.getRequest().absoluteURI();
        }

        public HttpMethod method() {
            return this.spanOperation.getRequest().method();
        }

        public MultiMap headers() {
            return this.spanOperation.getRequest().headers();
        }

        public SocketAddress remoteAddress() {
            return this.spanOperation.getRequest().remoteAddress();
        }

        static SpanRequest request(SpanOperation spanOperation) {
            return new SpanRequest(spanOperation);
        }
    }

    static class SpanOperation {
        private final io.vertx.core.Context context;
        private final HttpRequest request;
        private final Context spanContext;
        private final Scope scope;

        public SpanOperation(io.vertx.core.Context context, HttpRequest request, Context spanContext, Scope scope) {
            this.context = context;
            this.request = request;
            this.spanContext = spanContext;
            this.scope = scope;
        }

        public io.vertx.core.Context getContext() {
            return this.context;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public Context getSpanContext() {
            return this.spanContext;
        }

        public Scope getScope() {
            return this.scope;
        }

        static SpanOperation span(io.vertx.core.Context context, HttpRequest request, Context spanContext, Scope scope) {
            return new SpanOperation(context, request, spanContext, scope);
        }
    }
}

