/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;

public class DropNamesSampler
implements Sampler {
    private final Sampler sampler;
    private final List<String> dropNames;

    public DropNamesSampler(Sampler sampler, List<String> dropNames) {
        this.sampler = sampler;
        this.dropNames = dropNames;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        if (spanKind.equals((Object)SpanKind.SERVER)) {
            for (String dropName : this.dropNames) {
                if (!name.startsWith(dropName)) continue;
                return SamplingResult.drop();
            }
        }
        return this.sampler.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        return this.sampler.getDescription();
    }
}

