/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import org.jboss.logging.Logger;

public class LateBoundSampler
implements Sampler {
    private static final Logger log = Logger.getLogger(LateBoundSampler.class);
    private boolean warningLogged = false;
    private Sampler delegate;

    public void setSamplerDelegate(Sampler delegate) {
        this.delegate = delegate;
    }

    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return SamplingResult.create((SamplingDecision)SamplingDecision.RECORD_AND_SAMPLE);
        }
        return this.delegate.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    public String getDescription() {
        if (this.delegate == null) {
            this.logDelegateNotFound();
            return "";
        }
        return this.delegate.getDescription();
    }

    private void logDelegateNotFound() {
        if (!this.warningLogged) {
            log.warn((Object)"No Sampler delegate specified, no action taken.");
            this.warningLogged = true;
        }
    }
}

