/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.quarkus.opentelemetry.runtime.OpenTelemetryUtil;
import io.quarkus.opentelemetry.runtime.tracing.DropNamesSampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRuntimeConfig;
import java.util.List;
import java.util.Optional;

public class TracerUtil {
    private TracerUtil() {
    }

    public static Resource mapResourceAttributes(List<String> resourceAttributes) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        OpenTelemetryUtil.convertKeyValueListToMap(resourceAttributes).forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return Resource.create((Attributes)attributesBuilder.build());
    }

    private static Sampler getBaseSampler(String samplerName, Optional<Double> ratio) {
        switch (samplerName) {
            case "on": {
                return Sampler.alwaysOn();
            }
            case "off": {
                return Sampler.alwaysOff();
            }
            case "ratio": {
                return Sampler.traceIdRatioBased((double)ratio.orElse(1.0));
            }
        }
        throw new IllegalArgumentException("Unrecognized value for sampler: " + samplerName);
    }

    public static Sampler mapSampler(TracerRuntimeConfig.SamplerConfig samplerConfig, List<String> dropNames) {
        Sampler sampler = TracerUtil.getBaseSampler(samplerConfig.samplerName, samplerConfig.ratio);
        if (!dropNames.isEmpty()) {
            sampler = new DropNamesSampler(sampler, dropNames);
        }
        if (samplerConfig.parentBased.booleanValue()) {
            return Sampler.parentBased((Sampler)sampler);
        }
        return sampler;
    }
}

