/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesExtractor;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.InstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracer;
import io.vertx.core.Context;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Map;
import java.util.function.BiConsumer;

public class SqlClientInstrumenterVertxTracer
implements InstrumenterVertxTracer<QueryTrace, QueryTrace> {
    private final Instrumenter<QueryTrace, QueryTrace> sqlClientInstrumenter;

    public SqlClientInstrumenterVertxTracer(OpenTelemetry openTelemetry) {
        SqlClientAttributesGetter sqlClientAttributesGetter = new SqlClientAttributesGetter();
        InstrumenterBuilder serverBuilder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.quarkus.opentelemetry", (SpanNameExtractor)DbClientSpanNameExtractor.create((io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter)sqlClientAttributesGetter));
        this.sqlClientInstrumenter = serverBuilder.addAttributesExtractor(SqlClientAttributesExtractor.create((io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter)sqlClientAttributesGetter)).buildClientInstrumenter((queryTrace, key, value) -> {});
    }

    @Override
    public <R> boolean canHandle(R request, TagExtractor<R> tagExtractor) {
        if (request instanceof QueryTrace) {
            return true;
        }
        return "sql".equals(tagExtractor.extract(request).get("db.type"));
    }

    @Override
    public <R> OpenTelemetryVertxTracer.SpanOperation sendRequest(Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        QueryTrace queryTrace = QueryTrace.queryTrace(tagExtractor.extract(request));
        return InstrumenterVertxTracer.super.sendRequest(context, kind, policy, queryTrace, operation, (BiConsumer)headers, (TagExtractor)tagExtractor);
    }

    @Override
    public <R> void receiveResponse(Context context, R response, OpenTelemetryVertxTracer.SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        InstrumenterVertxTracer.super.receiveResponse(context, response, spanOperation, failure, tagExtractor);
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getReceiveRequestInstrumenter() {
        return null;
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getSendResponseInstrumenter() {
        return null;
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getSendRequestInstrumenter() {
        return this.sqlClientInstrumenter;
    }

    @Override
    public Instrumenter<QueryTrace, QueryTrace> getReceiveResponseInstrumenter() {
        return this.sqlClientInstrumenter;
    }

    static class SqlClientAttributesGetter
    implements io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter<QueryTrace> {
        SqlClientAttributesGetter() {
        }

        public String getRawStatement(QueryTrace queryTrace) {
            return queryTrace.rawStatement();
        }

        public String getSystem(QueryTrace queryTrace) {
            return queryTrace.system();
        }

        public String getUser(QueryTrace queryTrace) {
            return queryTrace.user();
        }

        public String getName(QueryTrace queryTrace) {
            return null;
        }

        public String getConnectionString(QueryTrace queryTrace) {
            return queryTrace.connectionString();
        }
    }

    static class QueryTrace {
        private final Map<String, String> attributes;

        QueryTrace(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        static QueryTrace queryTrace(Map<String, String> attributes) {
            return new QueryTrace(attributes);
        }

        public String rawStatement() {
            return this.attributes.get("db.statement");
        }

        public String system() {
            return this.attributes.get("db.instance");
        }

        public String user() {
            return this.attributes.get("db.user");
        }

        public String connectionString() {
            return this.attributes.get("peer.address");
        }
    }
}

