/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor;

import io.quarkus.dependencies.Category;
import io.quarkus.dependencies.Extension;
import io.quarkus.platform.descriptor.ResourceInputStreamConsumer;
import io.quarkus.platform.descriptor.ResourcePathConsumer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;

public interface QuarkusPlatformDescriptor {
    public String getBomGroupId();

    public String getBomArtifactId();

    public String getBomVersion();

    public String getQuarkusVersion();

    default public List<Dependency> getManagedDependencies() {
        throw new UnsupportedOperationException();
    }

    public List<Extension> getExtensions();

    public List<Category> getCategories();

    default public Map<String, Object> getMetadata() {
        return Collections.emptyMap();
    }

    public String getTemplate(String var1);

    public <T> T loadResource(String var1, ResourceInputStreamConsumer<T> var2) throws IOException;

    public <T> T loadResourceAsPath(String var1, ResourcePathConsumer<T> var2) throws IOException;

    default public String gav() {
        return String.format("%s:%s:%s", this.getBomGroupId(), this.getBomArtifactId(), this.getBomVersion());
    }
}

