/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dependencies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public class Extension
implements Serializable {
    public static final String GROUP_ID = "group-id";
    public static final String ARTIFACT_ID = "artifact-id";
    public static final String VERSION = "version";
    public static final String MD_SHORT_NAME = "short-name";
    public static final String MD_CODESTART = "codestart";
    public static final String MD_GUIDE = "guide";
    public static String MD_KEYWORDS = "keywords";
    public static final String MD_UNLISTED = "unlisted";
    public static final String MD_STATUS = "status";
    private String artifactId;
    private String groupId;
    private String scope;
    private String version;
    private String type;
    private String classifier;
    private String name;
    private String description;
    private String simplifiedArtifactId;
    private static final transient Pattern QUARKUS_PREFIX = Pattern.compile("^quarkus-");
    private Map<String, Object> metadata = new HashMap<String, Object>(3);

    public Extension() {
    }

    public Extension(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.setArtifactId(artifactId);
        this.version = version;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Extension setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        this.simplifiedArtifactId = QUARKUS_PREFIX.matcher(artifactId).replaceFirst("");
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Extension setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public Extension setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Extension setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Extension setType(String type) {
        this.type = type;
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Extension setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Extension setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Extension setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Extension setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<String> getKeywords() {
        List kw = (List)this.getMetadata().get(MD_KEYWORDS);
        return kw == null ? Collections.emptyList() : kw;
    }

    public Extension setKeywords(String[] keywords) {
        this.getMetadata().put(MD_KEYWORDS, Arrays.asList(keywords));
        return this;
    }

    public List<String> labelsForMatching() {
        ArrayList<String> list = new ArrayList<String>();
        List<String> keywords = this.getKeywords();
        if (keywords != null) {
            list.addAll(keywords.stream().map(String::toLowerCase).collect(Collectors.toList()));
        }
        list.add(this.artifactId.toLowerCase());
        return list;
    }

    public Dependency toDependency(boolean stripVersion) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.groupId);
        dependency.setArtifactId(this.artifactId);
        if (this.scope != null && !this.scope.isEmpty()) {
            dependency.setScope(this.scope);
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            dependency.setClassifier(this.classifier);
        }
        if (this.version != null && !this.version.isEmpty() && !stripVersion) {
            dependency.setVersion(this.version);
        }
        if (this.type != null && !this.type.isEmpty()) {
            dependency.setType(this.type);
        }
        return dependency;
    }

    public String managementKey() {
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public String gav() {
        return this.managementKey() + ":" + this.version;
    }

    public String getSimplifiedArtifactId() {
        return this.simplifiedArtifactId;
    }

    public String toString() {
        return this.gav();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extension extension = (Extension)o;
        return Objects.equals(this.artifactId, extension.artifactId) && Objects.equals(this.groupId, extension.groupId) && Objects.equals(this.version, extension.version);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.groupId, this.version);
    }

    public Extension setGuide(String guide) {
        this.getMetadata().put(MD_GUIDE, guide);
        return this;
    }

    public String getGuide() {
        return (String)this.getMetadata().get(MD_GUIDE);
    }

    public String getShortName() {
        String shortName = (String)this.getMetadata().get(MD_SHORT_NAME);
        if (shortName == null) {
            return this.name;
        }
        return shortName;
    }

    public Extension setShortName(String shortName) {
        this.getMetadata().put(MD_SHORT_NAME, shortName);
        return this;
    }

    public String getCodestart() {
        return (String)this.getMetadata().get(MD_CODESTART);
    }

    public Extension setCodestart(String codestart) {
        this.getMetadata().put(MD_CODESTART, codestart);
        return this;
    }

    public boolean isUnlisted() {
        Object val = this.getMetadata().get(MD_UNLISTED);
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        return false;
    }

    public void setUnlisted(boolean unlisted) {
        this.getMetadata().put(MD_UNLISTED, unlisted);
    }

    public Extension addMetadata(String key, Object value) {
        this.getMetadata().put(key, value);
        return this;
    }

    public Extension removeMetadata(String key) {
        this.getMetadata().remove(key);
        return this;
    }
}

