/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor;

import io.quarkus.dependencies.Category;
import io.quarkus.dependencies.Extension;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.descriptor.ResourceInputStreamConsumer;
import io.quarkus.platform.descriptor.ResourcePathConsumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.Dependency;

public class CombinedQuarkusPlatformDescriptor
implements QuarkusPlatformDescriptor {
    private final QuarkusPlatformDescriptor master;
    private final List<QuarkusPlatformDescriptor> platforms;
    private List<Dependency> managedDeps;
    private List<Extension> extensions;
    private List<Category> categories;
    private Map<String, Object> metadata;

    public static Builder builder() {
        return new Builder();
    }

    private CombinedQuarkusPlatformDescriptor(Builder builder) {
        if (builder.platforms.isEmpty()) {
            throw new IllegalArgumentException("No platforms to combine");
        }
        this.master = (QuarkusPlatformDescriptor)builder.platforms.get(0);
        this.platforms = new ArrayList<QuarkusPlatformDescriptor>(builder.platforms);
    }

    @Override
    public String getBomGroupId() {
        return this.master.getBomGroupId();
    }

    @Override
    public String getBomArtifactId() {
        return this.master.getBomArtifactId();
    }

    @Override
    public String getBomVersion() {
        return this.master.getBomVersion();
    }

    @Override
    public String getQuarkusVersion() {
        return this.master.getQuarkusVersion();
    }

    @Override
    public Map<String, Object> getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        for (int i = this.platforms.size() - 1; i >= 0; --i) {
            metadata.putAll(this.platforms.get(i).getMetadata());
        }
        this.metadata = metadata;
        return this.metadata;
    }

    @Override
    public List<Dependency> getManagedDependencies() {
        if (this.managedDeps != null) {
            return this.managedDeps;
        }
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        HashSet<DepKey> depKeys = new HashSet<DepKey>();
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            for (Dependency dep : platform.getManagedDependencies()) {
                if (!depKeys.add(new DepKey(dep))) continue;
                deps.add(dep);
            }
        }
        this.managedDeps = deps;
        return this.managedDeps;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        ArrayList<Extension> list = new ArrayList<Extension>();
        HashSet<DepKey> depKeys = new HashSet<DepKey>();
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            for (Extension ext : platform.getExtensions()) {
                if (!depKeys.add(new DepKey(ext.getGroupId(), ext.getArtifactId()))) continue;
                list.add(ext);
            }
        }
        this.extensions = list;
        return this.extensions;
    }

    @Override
    public List<Category> getCategories() {
        if (this.categories != null) {
            return this.categories;
        }
        ArrayList<Category> list = new ArrayList<Category>();
        HashSet<String> ids = new HashSet<String>();
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            for (Category cat : platform.getCategories()) {
                if (!ids.add(cat.getId())) continue;
                list.add(cat);
            }
        }
        this.categories = list;
        return this.categories;
    }

    @Override
    public String getTemplate(String name) {
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            String template = platform.getTemplate(name);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    @Override
    public <T> T loadResource(String name, ResourceInputStreamConsumer<T> consumer) throws IOException {
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            try {
                return platform.loadResource(name, consumer);
            }
            catch (IOException iOException) {
            }
        }
        throw new IOException("Failed to locate resource " + name);
    }

    @Override
    public <T> T loadResourceAsPath(String name, ResourcePathConsumer<T> consumer) throws IOException {
        for (QuarkusPlatformDescriptor platform : this.platforms) {
            try {
                return platform.loadResourceAsPath(name, consumer);
            }
            catch (IOException iOException) {
            }
        }
        throw new IOException("Failed to locate resource " + name);
    }

    private static class DepKey {
        final String groupId;
        final String artifactId;
        final String classifier;
        final String type;

        DepKey(Dependency dep) {
            this(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getType());
        }

        DepKey(String groupId, String artifactId) {
            this(groupId, artifactId, null, null);
        }

        DepKey(String groupId, String artifactId, String classifier, String type) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DepKey)) {
                return false;
            }
            DepKey depKey = (DepKey)o;
            return Objects.equals(this.groupId, depKey.groupId) && Objects.equals(this.artifactId, depKey.artifactId) && Objects.equals(this.classifier, depKey.classifier) && Objects.equals(this.type, depKey.type);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.classifier, this.type);
        }
    }

    public static class Builder {
        private final List<QuarkusPlatformDescriptor> platforms = new ArrayList<QuarkusPlatformDescriptor>();

        private Builder() {
        }

        public Builder addPlatform(QuarkusPlatformDescriptor platform) {
            this.platforms.add(platform);
            return this;
        }

        public QuarkusPlatformDescriptor build() {
            return new CombinedQuarkusPlatformDescriptor(this);
        }
    }
}

