/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.PublisherFactory;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.Variant;
import io.quarkus.qute.api.ResourcePath;
import io.quarkus.qute.api.VariantTemplate;
import io.quarkus.qute.deployment.GeneratedValueResolverBuildItem;
import io.quarkus.qute.deployment.ImplicitValueResolverBuildItem;
import io.quarkus.qute.deployment.IncorrectExpressionBuildItem;
import io.quarkus.qute.deployment.TemplateExtensionMethodBuildItem;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.TemplateVariantsBuildItem;
import io.quarkus.qute.deployment.TemplatesAnalysisBuildItem;
import io.quarkus.qute.deployment.TypeCheckExcludeBuildItem;
import io.quarkus.qute.deployment.TypeCheckInfo;
import io.quarkus.qute.deployment.Types;
import io.quarkus.qute.generator.ExtensionMethodGenerator;
import io.quarkus.qute.generator.ValueResolverGenerator;
import io.quarkus.qute.runtime.BuiltinTemplateExtensions;
import io.quarkus.qute.runtime.EngineProducer;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.TemplateProducer;
import io.quarkus.qute.runtime.VariantTemplateProducer;
import io.quarkus.qute.rxjava.RxjavaPublisherFactory;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class QuteProcessor {
    private static final Logger LOGGER = Logger.getLogger(QuteProcessor.class);
    public static final DotName RESOURCE_PATH = DotName.createSimple((String)ResourcePath.class.getName());
    public static final DotName TEMPLATE = DotName.createSimple((String)Template.class.getName());
    public static final DotName VARIANT_TEMPLATE = DotName.createSimple((String)VariantTemplate.class.getName());
    static final DotName ITERABLE = DotName.createSimple((String)Iterable.class.getName());
    static final DotName STREAM = DotName.createSimple((String)Stream.class.getName());
    static final DotName MAP = DotName.createSimple((String)Map.class.getName());
    static final DotName MAP_ENTRY = DotName.createSimple((String)Map.Entry.class.getName());
    private static final String MATCH_NAME = "matchName";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("qute");
    }

    @BuildStep
    void processTemplateErrors(TemplatesAnalysisBuildItem analysis, List<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ServiceStartBuildItem> serviceStart) {
        ArrayList<String> errors = new ArrayList<String>();
        for (IncorrectExpressionBuildItem incorrectExpression : incorrectExpressions) {
            if (incorrectExpression.clazz != null) {
                errors.add(String.format("Incorrect expression: %s\n\t- property [%s] not found on class [%s] nor handled by an extension method\n\t- found in template [%s] on line %s", incorrectExpression.expression, incorrectExpression.property, incorrectExpression.clazz, this.findTemplatePath(analysis, incorrectExpression.templateId), incorrectExpression.line));
                continue;
            }
            errors.add(String.format("Incorrect expression %s\n\t @Named bean not found for [%s]\n\t- found in template [%s] on line %s", incorrectExpression.expression, incorrectExpression.property, this.findTemplatePath(analysis, incorrectExpression.templateId), incorrectExpression.line));
        }
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder("Found " + errors.size() + " template problems: ");
            int idx = 1;
            for (String errorMessage : errors) {
                message.append("\n").append("[").append(idx++).append("] ").append(errorMessage);
            }
            throw new TemplateException(message.toString());
        }
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{EngineProducer.class, TemplateProducer.class, VariantTemplateProducer.class, ResourcePath.class, Template.class, TemplateInstance.class, BuiltinTemplateExtensions.class}).build();
    }

    @BuildStep
    TemplatesAnalysisBuildItem analyzeTemplates(final List<TemplatePathBuildItem> templatePaths) {
        long start = System.currentTimeMillis();
        ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis> analysis = new ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis>();
        Engine dummyEngine = Engine.builder().addDefaultSectionHelpers().computeSectionHelper(name -> new SectionHelperFactory<SectionHelper>(){

            public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
                return new SectionHelper(){

                    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
                        return CompletableFuture.completedFuture(ResultNode.NOOP);
                    }
                };
            }
        }).addLocator(new TemplateLocator(){

            public Optional<TemplateLocator.TemplateLocation> locate(String id) {
                TemplatePathBuildItem found = templatePaths.stream().filter(p -> p.getPath().equals(id)).findAny().orElse(null);
                if (found != null) {
                    try {
                        final byte[] content = Files.readAllBytes(found.getFullPath());
                        return Optional.of(new TemplateLocator.TemplateLocation(){

                            public Reader read() {
                                return new StringReader(new String(content, StandardCharsets.UTF_8));
                            }

                            public Optional<Variant> getVariant() {
                                return Optional.empty();
                            }
                        });
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)("Unable to read the template from path: " + found.getFullPath()), (Throwable)e);
                    }
                }
                return Optional.empty();
            }
        }).build();
        for (TemplatePathBuildItem path : templatePaths) {
            Template template = dummyEngine.getTemplate(path.getPath());
            if (template == null) continue;
            analysis.add(new TemplatesAnalysisBuildItem.TemplateAnalysis(template.getGeneratedId(), template.getExpressions(), path));
        }
        LOGGER.debugf("Finished analysis of %s templates  in %s ms", (long)analysis.size(), System.currentTimeMillis() - start);
        return new TemplatesAnalysisBuildItem(analysis);
    }

    @BuildStep
    void validateExpressions(final TemplatesAnalysisBuildItem templatesAnalysis, BeanArchiveIndexBuildItem beanArchiveIndex, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> excludes, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ImplicitValueResolverBuildItem> requiredClasses) {
        IndexView index = beanArchiveIndex.getIndex();
        Function<String, String> templateIdToPathFun = new Function<String, String>(){

            @Override
            public String apply(String id) {
                return QuteProcessor.this.findTemplatePath(templatesAnalysis, id);
            }
        };
        for (TemplatesAnalysisBuildItem.TemplateAnalysis analysis : templatesAnalysis.getAnalysis()) {
            block1: for (Expression expression : analysis.expressions) {
                if (expression.typeCheckInfo == null) continue;
                TypeCheckInfo typeCheckInfo = TypeCheckInfo.create(expression, index, templateIdToPathFun);
                if (typeCheckInfo.parts.isEmpty()) continue;
                Iterator<String> parts = typeCheckInfo.parts.iterator();
                Match match = new Match();
                match.clazz = typeCheckInfo.rawClass;
                match.type = typeCheckInfo.resolvedType;
                String rootHint = typeCheckInfo.getHelperHint("$$root$$");
                if (rootHint != null) {
                    this.processHints(rootHint, match, index);
                }
                while (parts.hasNext()) {
                    String name = parts.next();
                    if (match.clazz == null) continue block1;
                    requiredClasses.produce((BuildItem)new ImplicitValueResolverBuildItem(match.clazz));
                    if (name.contains("(")) continue block1;
                    AnnotationTarget member = this.findProperty(name, match.clazz, index);
                    if (member == null) {
                        member = this.findTemplateExtensionMethod(name, match.clazz, templateExtensionMethods);
                    }
                    if (member == null && excludes.stream().anyMatch(e -> e.getPredicate().test(name, match.clazz))) {
                        LOGGER.debugf("No property found for %s in [%s] but it is intentionally ignored", (Object)name, (Object)expression.toOriginalString(), (Object)match.clazz);
                        continue block1;
                    }
                    if (member == null) {
                        incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), name, match.clazz.toString(), expression.origin.getLine(), expression.origin.getTemplateId()));
                        continue block1;
                    }
                    match.type = this.resolveType(member, match, index);
                    if (match.type.kind() == Type.Kind.PRIMITIVE) continue block1;
                    match.clazz = index.getClassByName(match.type.name());
                    String helperHint = typeCheckInfo.getHelperHint(name);
                    if (helperHint == null) continue;
                    this.processHints(helperHint, match, index);
                }
            }
        }
    }

    @BuildStep
    void collectTemplateExtensionMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<MethodInfo, AnnotationInstance> methods = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<ClassInfo, AnnotationInstance> classes = new HashMap<ClassInfo, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : index.getAnnotations(ExtensionMethodGenerator.TEMPLATE_EXTENSION)) {
            if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                methods.put(annotationInstance.target().asMethod(), annotationInstance);
                continue;
            }
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            classes.put(annotationInstance.target().asClass(), annotationInstance);
        }
        for (Map.Entry entry : methods.entrySet()) {
            MethodInfo method = (MethodInfo)entry.getKey();
            ExtensionMethodGenerator.validate((MethodInfo)method);
            this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
            LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
        }
        for (Map.Entry entry : classes.entrySet()) {
            ClassInfo clazz = (ClassInfo)entry.getKey();
            for (MethodInfo method : clazz.methods()) {
                if (!Modifier.isStatic(method.flags()) || method.returnType().kind() == Type.Kind.VOID || method.parameters().isEmpty() || Modifier.isPrivate(method.flags()) || methods.containsKey(method)) continue;
                this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
                LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
            }
        }
    }

    private void produceExtensionMethod(IndexView index, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods, MethodInfo method, AnnotationInstance extensionAnnotation) {
        String matchName = null;
        AnnotationValue matchNameValue = extensionAnnotation.value(MATCH_NAME);
        if (matchNameValue != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null) {
            matchName = method.name();
        }
        extensionMethods.produce((BuildItem)new TemplateExtensionMethodBuildItem(method, matchName, index.getClassByName(((Type)method.parameters().get(0)).name())));
    }

    @BuildStep
    void validateBeansInjectedInTemplates(ApplicationArchivesBuildItem applicationArchivesBuildItem, final TemplatesAnalysisBuildItem analysis, BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> excludes, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationError, BuildProducer<ImplicitValueResolverBuildItem> requiredClasses) {
        IndexView index = beanArchiveIndex.getIndex();
        Function<String, String> templateIdToPathFun = new Function<String, String>(){

            @Override
            public String apply(String id) {
                return QuteProcessor.this.findTemplatePath(analysis, id);
            }
        };
        Set<Expression> injectExpressions = this.collectInjectExpressions(analysis);
        if (!injectExpressions.isEmpty()) {
            BeanDeploymentValidator.ValidationContext context = validationPhase.getContext();
            Map namedBeans = ((Collection)context.get(BuildExtension.Key.BEANS)).stream().filter(b -> b.getName() != null).collect(Collectors.toMap(BeanInfo::getName, Function.identity()));
            Set<Expression> expressions = this.collectInjectExpressions(analysis);
            block0: for (Expression expression : expressions) {
                String beanName = (String)expression.parts.get(0);
                BeanInfo bean = (BeanInfo)namedBeans.get(beanName);
                if (bean != null) {
                    if (expression.parts.size() == 1) continue;
                    TypeCheckInfo typeCheckInfo = TypeCheckInfo.create(expression, index, templateIdToPathFun);
                    if (typeCheckInfo.parts.isEmpty()) continue;
                    ListIterator parts = expression.parts.listIterator(1);
                    Match match = new Match();
                    match.clazz = bean.getImplClazz();
                    while (parts.hasNext()) {
                        String name = (String)parts.next();
                        if (match.clazz == null) continue block0;
                        requiredClasses.produce((BuildItem)new ImplicitValueResolverBuildItem(match.clazz));
                        if (name.contains("(")) continue block0;
                        AnnotationTarget member = this.findProperty(name, match.clazz, index);
                        if (member == null) {
                            member = this.findTemplateExtensionMethod(name, match.clazz, templateExtensionMethods);
                        }
                        if (member == null && excludes.stream().anyMatch(e -> e.getPredicate().test(name, match.clazz))) {
                            LOGGER.debugf("No property found for %s in [%s] but it is intentionally ignored", (Object)name, (Object)expression.toOriginalString(), (Object)match.clazz);
                            continue block0;
                        }
                        if (member == null) {
                            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), name, match.clazz.toString(), expression.origin.getLine(), expression.origin.getTemplateId()));
                            continue block0;
                        }
                        if (member.kind() == AnnotationTarget.Kind.FIELD) {
                            match.type = member.asField().type();
                        } else if (member.kind() == AnnotationTarget.Kind.METHOD) {
                            match.type = member.asMethod().returnType();
                        } else {
                            throw new IllegalStateException("Unsupported member type: " + member);
                        }
                        if (match.type.kind() == Type.Kind.PRIMITIVE) continue block0;
                        match.clazz = index.getClassByName(match.type.name());
                        String helperHint = typeCheckInfo.getHelperHint(name);
                        if (helperHint == null) continue;
                        this.processHints(helperHint, match, index);
                    }
                    continue;
                }
                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), beanName, null, expression.origin.getLine(), expression.origin.getTemplateId()));
            }
        }
    }

    private String findTemplatePath(TemplatesAnalysisBuildItem analysis, String id) {
        for (TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis : analysis.getAnalysis()) {
            if (!templateAnalysis.id.equals(id)) continue;
            return templateAnalysis.path.getPath();
        }
        return null;
    }

    @BuildStep
    void generateValueResolvers(QuteConfig config, final BuildProducer<GeneratedClassBuildItem> generatedClass, CombinedIndexBuildItem combinedIndex, BeanArchiveIndexBuildItem beanArchiveIndex, final ApplicationArchivesBuildItem applicationArchivesBuildItem, List<TemplatePathBuildItem> templatePaths, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<ImplicitValueResolverBuildItem> requiredClasses, TemplatesAnalysisBuildItem templatesAnalysis, BuildProducer<GeneratedValueResolverBuildItem> generatedResolvers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = beanArchiveIndex.getIndex();
        final Predicate<String> appClassPredicate = new Predicate<String>(){

            @Override
            public boolean test(String name) {
                return applicationArchivesBuildItem.getRootArchive().getIndex().getClassByName(DotName.createSimple((String)name)) != null;
            }
        };
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                String className;
                int idx = name.lastIndexOf("_Extension_ValueResolver");
                if (idx == -1) {
                    idx = name.lastIndexOf("_ValueResolver");
                }
                if ((className = name.substring(0, idx).replace("/", ".")).contains("$_")) {
                    className = className.replace("$_", "$");
                }
                boolean appClass = appClassPredicate.test(className);
                LOGGER.debugf("Writing %s [appClass=%s]", (Object)name, (Object)appClass);
                generatedClass.produce((BuildItem)new GeneratedClassBuildItem(appClass, name, data));
            }
        };
        HashSet<ClassInfo> controlled = new HashSet<ClassInfo>();
        HashMap<ClassInfo, AnnotationInstance> uncontrolled = new HashMap<ClassInfo, AnnotationInstance>();
        for (AnnotationInstance templateData : index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA)) {
            this.processsTemplateData(index, templateData, templateData.target(), controlled, uncontrolled);
        }
        for (AnnotationInstance containerInstance : index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA_CONTAINER)) {
            for (AnnotationInstance templateData : containerInstance.value().asNestedArray()) {
                this.processsTemplateData(index, templateData, containerInstance.target(), controlled, uncontrolled);
            }
        }
        for (Object required : requiredClasses) {
            if (controlled.contains(required.getClazz()) || uncontrolled.containsKey(required.getClazz())) continue;
            controlled.add(required.getClazz());
        }
        ValueResolverGenerator generator = ValueResolverGenerator.builder().setIndex(index).setClassOutput(classOutput).setUncontrolled(uncontrolled).build();
        for (ClassInfo data : controlled) {
            generator.generate(data);
        }
        for (ClassInfo data : uncontrolled.keySet()) {
            generator.generate(data);
        }
        HashSet generatedTypes = new HashSet();
        generatedTypes.addAll(generator.getGeneratedTypes());
        ExtensionMethodGenerator extensionMethodGenerator = new ExtensionMethodGenerator(classOutput);
        for (TemplateExtensionMethodBuildItem templateExtension : templateExtensionMethods) {
            extensionMethodGenerator.generate(templateExtension.getMethod(), templateExtension.getMatchName());
        }
        generatedTypes.addAll(extensionMethodGenerator.getGeneratedTypes());
        LOGGER.debugf("Generated types: %s", generatedTypes);
        for (String generateType : generatedTypes) {
            generatedResolvers.produce((BuildItem)new GeneratedValueResolverBuildItem(generateType));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{generateType}));
        }
    }

    @BuildStep
    void collectTemplates(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources) throws IOException {
        String tagBasePath;
        Path tagsPath;
        String basePath;
        ApplicationArchive applicationArchive = applicationArchivesBuildItem.getRootArchive();
        Path templatesPath = applicationArchive.getChildPath(basePath = "templates/");
        if (templatesPath != null) {
            this.scan(templatesPath, templatesPath, basePath, watchedPaths, templatePaths, nativeImageResources);
        }
        if ((tagsPath = applicationArchive.getChildPath(tagBasePath = basePath + "tags/")) != null) {
            try (Stream<Path> tagFiles = Files.list(tagsPath);){
                Iterator iter = tagFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).iterator();
                while (iter.hasNext()) {
                    Path path = (Path)iter.next();
                    String tagPath = path.getFileName().toString();
                    LOGGER.debugf("Found tag: %s", (Object)path);
                    QuteProcessor.produceTemplateBuildItems(templatePaths, watchedPaths, nativeImageResources, tagBasePath, tagPath, path, true);
                }
            }
        }
    }

    @BuildStep
    void validateTemplateInjectionPoints(QuteConfig config, List<TemplatePathBuildItem> templatePaths, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        HashSet<String> filePaths = new HashSet<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            String path2 = templatePath.getPath();
            filePaths.add(path2);
            for (String suffix : config.suffixes) {
                if (!path2.endsWith(suffix)) continue;
                filePaths.add(path2.substring(0, path2.length() - (suffix.length() + 1)));
            }
        }
        for (InjectionPointInfo injectionPoint : (Collection)validationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            String name;
            AnnotationInstance resourcePath;
            if (injectionPoint.getRequiredType().name().equals((Object)TEMPLATE)) {
                resourcePath = injectionPoint.getRequiredQualifier(RESOURCE_PATH);
                name = resourcePath != null ? resourcePath.value().asString() : (injectionPoint.hasDefaultedQualifier() ? QuteProcessor.getName(injectionPoint) : null);
                if (name == null || !filePaths.stream().noneMatch(path -> path.endsWith(name))) continue;
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("No template found for " + injectionPoint.getTargetInfo())}));
                continue;
            }
            if (!injectionPoint.getRequiredType().name().equals((Object)VARIANT_TEMPLATE) || (name = (resourcePath = injectionPoint.getRequiredQualifier(RESOURCE_PATH)) != null ? resourcePath.value().asString() : (injectionPoint.hasDefaultedQualifier() ? QuteProcessor.getName(injectionPoint) : null)) == null || !filePaths.stream().noneMatch(path -> path.endsWith(name))) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("No variant template found for " + injectionPoint.getTargetInfo())}));
        }
    }

    @BuildStep
    TemplateVariantsBuildItem collectTemplateVariants(List<TemplatePathBuildItem> templatePaths) throws IOException {
        Set allPaths = templatePaths.stream().map(TemplatePathBuildItem::getPath).collect(Collectors.toSet());
        HashMap<String, List<String>> baseToVariants = new HashMap<String, List<String>>();
        for (String path : allPaths) {
            int idx = path.lastIndexOf(46);
            if (idx == -1) continue;
            String base = path.substring(0, idx);
            ArrayList<String> variants = (ArrayList<String>)baseToVariants.get(base);
            if (variants == null) {
                variants = new ArrayList<String>();
                baseToVariants.put(base, variants);
            }
            variants.add(path);
        }
        LOGGER.debugf("Variant templates found: %s", baseToVariants);
        return new TemplateVariantsBuildItem(baseToVariants);
    }

    @BuildStep
    ServiceProviderBuildItem registerPublisherFactory() {
        return new ServiceProviderBuildItem(PublisherFactory.class.getName(), new String[]{RxjavaPublisherFactory.class.getName()});
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void initialize(QuteRecorder recorder, QuteConfig config, List<GeneratedValueResolverBuildItem> generatedValueResolvers, List<TemplatePathBuildItem> templatePaths, Optional<TemplateVariantsBuildItem> templateVariants, BeanContainerBuildItem beanContainer, List<ServiceStartBuildItem> startedServices) {
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            if (templatePath.isTag()) {
                tags.add(templatePath.getPath());
                continue;
            }
            templates.add(templatePath.getPath());
        }
        recorder.initEngine(config, beanContainer.getValue(), generatedValueResolvers.stream().map(GeneratedValueResolverBuildItem::getClassName).collect(Collectors.toList()), templates, tags);
        Map<Object, Object> variants = templateVariants.isPresent() ? templateVariants.get().getVariants() : Collections.emptyMap();
        recorder.initVariants(beanContainer.getValue(), variants);
    }

    private Type resolveType(AnnotationTarget member, Match match, IndexView index) {
        Type matchType;
        if (member.kind() == AnnotationTarget.Kind.FIELD) {
            matchType = member.asField().type();
        } else if (member.kind() == AnnotationTarget.Kind.METHOD) {
            matchType = member.asMethod().returnType();
        } else {
            throw new IllegalStateException("Unsupported member type: " + member);
        }
        if (matchType.kind() == Type.Kind.PARAMETERIZED_TYPE || matchType.kind() == Type.Kind.TYPE_VARIABLE) {
            Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.type.asParameterizedType().arguments(), match.clazz.typeParameters(), new HashMap<TypeVariable, Type>(), index), index);
            DotName declaringClassName = member.kind() == AnnotationTarget.Kind.METHOD ? member.asMethod().declaringClass().name() : member.asField().declaringClass().name();
            Type declaringType = closure.stream().filter(t -> t.name().equals((Object)declaringClassName)).findAny().orElse(null);
            if (declaringType != null && declaringType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                matchType = Types.resolveTypeParam(matchType, Types.buildResolvedMap(declaringType.asParameterizedType().arguments(), index.getClassByName(declaringType.name()).typeParameters(), Collections.emptyMap(), index), index);
            }
        }
        return matchType;
    }

    void processHints(String helperHint, Match match, IndexView index) {
        if ("<for-element>".equals(helperHint)) {
            this.processLoopHint(match, index);
        }
    }

    void processLoopHint(Match match, IndexView index) {
        Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.type.asParameterizedType().arguments(), match.clazz.typeParameters(), new HashMap<TypeVariable, Type>(), index), index);
        Type matchType = null;
        Type iterableType = closure.stream().filter(t -> t.name().equals((Object)ITERABLE)).findFirst().orElse(null);
        if (iterableType != null) {
            matchType = (Type)iterableType.asParameterizedType().arguments().get(0);
        } else {
            Type streamType = closure.stream().filter(t -> t.name().equals((Object)STREAM)).findFirst().orElse(null);
            if (streamType != null) {
                matchType = (Type)streamType.asParameterizedType().arguments().get(0);
            } else {
                Type mapType = closure.stream().filter(t -> t.name().equals((Object)MAP)).findFirst().orElse(null);
                if (mapType != null) {
                    Type[] args = new Type[]{(Type)mapType.asParameterizedType().arguments().get(0), (Type)mapType.asParameterizedType().arguments().get(1)};
                    matchType = ParameterizedType.create((DotName)MAP_ENTRY, (Type[])args, null);
                }
            }
        }
        if (matchType == null) {
            throw new IllegalStateException("Unable to process the loop section hint for type: " + match.type);
        }
        match.type = matchType;
        match.clazz = index.getClassByName(match.type.name());
    }

    private AnnotationTarget findTemplateExtensionMethod(String name, ClassInfo matchClass, List<TemplateExtensionMethodBuildItem> templateExtensionMethods) {
        for (TemplateExtensionMethodBuildItem templateExtensionMethod : templateExtensionMethods) {
            if (!templateExtensionMethod.matchesClass(matchClass) || !templateExtensionMethod.matchesName(name)) continue;
            return templateExtensionMethod.getMethod();
        }
        return null;
    }

    private AnnotationTarget findProperty(String property, ClassInfo clazz, IndexView index) {
        int start = property.indexOf("(");
        if (start != -1) {
            property = property.substring(0, start);
        }
        while (clazz != null) {
            for (FieldInfo field : clazz.fields()) {
                if (!Modifier.isPublic(field.flags()) || Modifier.isStatic(field.flags()) || ValueResolverGenerator.isSynthetic((int)field.flags()) || !field.name().equals(property)) continue;
                return field;
            }
            for (MethodInfo method : clazz.methods()) {
                if (!Modifier.isPublic(method.flags()) || Modifier.isStatic(method.flags()) || ValueResolverGenerator.isSynthetic((int)method.flags()) || !method.name().equals(property) && !ValueResolverGenerator.getPropertyName((String)method.name()).equals(property)) continue;
                return method;
            }
            DotName superName = clazz.superName();
            if (superName == null || DotNames.OBJECT.equals((Object)superName)) {
                clazz = null;
                continue;
            }
            clazz = index.getClassByName(clazz.superName());
        }
        return null;
    }

    private void processsTemplateData(IndexView index, AnnotationInstance templateData, AnnotationTarget annotationTarget, Set<ClassInfo> controlled, Map<ClassInfo, AnnotationInstance> uncontrolled) {
        AnnotationValue targetValue = templateData.value("target");
        if (targetValue == null || targetValue.asClass().name().equals((Object)ValueResolverGenerator.TEMPLATE_DATA)) {
            controlled.add(annotationTarget.asClass());
        } else {
            ClassInfo uncontrolledClass = index.getClassByName(targetValue.asClass().name());
            if (uncontrolledClass != null) {
                uncontrolled.compute(uncontrolledClass, (c, v) -> {
                    AnnotationValue propertiesValue;
                    if (v == null) {
                        return templateData;
                    }
                    AnnotationValue ignoreValue = templateData.value("ignore");
                    if (ignoreValue == null || !ignoreValue.equals((Object)v.value("ignore"))) {
                        ignoreValue = AnnotationValue.createArrayValue((String)"ignore", (AnnotationValue[])new AnnotationValue[0]);
                    }
                    if ((propertiesValue = templateData.value("properties")) == null || propertiesValue.equals((Object)v.value("properties"))) {
                        propertiesValue = AnnotationValue.createBooleanValue((String)"properties", (boolean)false);
                    }
                    return AnnotationInstance.create((DotName)templateData.name(), (AnnotationTarget)templateData.target(), (AnnotationValue[])new AnnotationValue[]{ignoreValue, propertiesValue});
                });
            } else {
                LOGGER.warnf("@TemplateData#target() not available: %s", (Object)annotationTarget.asClass().name());
            }
        }
    }

    private Set<Expression> collectInjectExpressions(TemplatesAnalysisBuildItem analysis) {
        HashSet<Expression> injectExpressions = new HashSet<Expression>();
        for (TemplatesAnalysisBuildItem.TemplateAnalysis template : analysis.getAnalysis()) {
            injectExpressions.addAll(this.collectInjectExpressions(template));
        }
        return injectExpressions;
    }

    private Set<Expression> collectInjectExpressions(TemplatesAnalysisBuildItem.TemplateAnalysis analysis) {
        HashSet<Expression> injectExpressions = new HashSet<Expression>();
        for (Expression expression : analysis.expressions) {
            if (expression.literal != null || !"inject".equals(expression.namespace)) continue;
            injectExpressions.add(expression);
        }
        return injectExpressions;
    }

    public static String getName(InjectionPointInfo injectionPoint) {
        if (injectionPoint.isField()) {
            return injectionPoint.getTarget().asField().name();
        }
        if (injectionPoint.isParam()) {
            String name = injectionPoint.getTarget().asMethod().parameterName(injectionPoint.getPosition());
            return name == null ? injectionPoint.getTarget().asMethod().name() : name;
        }
        throw new IllegalArgumentException();
    }

    private static void produceTemplateBuildItems(BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, String basePath, String filePath, Path originalPath, boolean tag) {
        if (filePath.isEmpty()) {
            return;
        }
        String fullPath = basePath + filePath;
        watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(fullPath, true));
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fullPath}));
        templatePaths.produce((BuildItem)new TemplatePathBuildItem(filePath, originalPath, tag));
    }

    private void scan(Path root, Path directory, String basePath, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    LOGGER.debugf("Found template: %s", (Object)filePath);
                    String templatePath = root.relativize(filePath).toString();
                    if (File.separatorChar != '/') {
                        templatePath = templatePath.replace(File.separatorChar, '/');
                    }
                    QuteProcessor.produceTemplateBuildItems(templatePaths, watchedPaths, nativeImageResources, basePath, templatePath, filePath, false);
                    continue;
                }
                if (!Files.isDirectory(filePath, new LinkOption[0]) || filePath.getFileName().toString().equals("tags")) continue;
                LOGGER.debugf("Scan directory: %s", (Object)filePath);
                this.scan(root, filePath, basePath, watchedPaths, templatePaths, nativeImageResources);
            }
        }
    }

    static class Match {
        ClassInfo clazz;
        Type type;

        Match() {
        }
    }
}

