/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.TemplateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

class TypeCheckInfo {
    static final String LEFT_ANGLE = "<";
    static final String RIGHT_ANGLE = ">";
    static final String RIGHT_BRACKET = "]";
    static final String ROOT_HINT = "$$root$$";
    final Type resolvedType;
    final ClassInfo rawClass;
    final List<String> parts;
    final Map<String, String> helperHints;

    static TypeCheckInfo create(Expression expression, IndexView index, Function<String, String> templateIdToPathFun) {
        Type resolvedType;
        ClassInfo rawClass;
        String classStr;
        Map<String, String> helperHints;
        List<String> parts;
        String value = expression.typeCheckInfo;
        int partsIdx = value.indexOf(RIGHT_BRACKET);
        if (partsIdx + 1 < value.length()) {
            String partsStr = value.substring(partsIdx + 1, value.length());
            parts = new ArrayList(Expressions.splitParts((String)partsStr));
            helperHints = new HashMap();
            String firstPart = (String)parts.get(0);
            if (firstPart.equals(TypeCheckInfo.helperHint(firstPart))) {
                parts.remove(0);
                helperHints.put(ROOT_HINT, firstPart);
            }
            ListIterator<String> iterator = parts.listIterator();
            while (iterator.hasNext()) {
                String part = iterator.next();
                String hint = TypeCheckInfo.helperHint(part);
                if (hint == null) continue;
                String val = part.substring(0, part.indexOf(LEFT_ANGLE));
                helperHints.put(val, hint);
                iterator.set(val);
            }
        } else {
            parts = Collections.emptyList();
            helperHints = Collections.emptyMap();
        }
        if ((classStr = value.substring(1, value.indexOf(RIGHT_BRACKET))).equals("$$namespace$$")) {
            rawClass = null;
            resolvedType = null;
        } else {
            DotName rawClassName = TypeCheckInfo.rawClassName(classStr);
            rawClass = index.getClassByName(rawClassName);
            if (rawClass == null) {
                throw new TemplateException("Class [" + rawClassName + "] used in the parameter declaration in template [" + templateIdToPathFun.apply(expression.origin.getTemplateId()) + "] on line " + expression.origin.getLine() + " was not found in the application index. Make sure it is spelled correctly.");
            }
            resolvedType = TypeCheckInfo.resolveType(classStr);
        }
        return new TypeCheckInfo(resolvedType, rawClass, parts, helperHints);
    }

    TypeCheckInfo(Type resolvedType, ClassInfo rawClass, List<String> parts, Map<String, String> helperHints) {
        this.resolvedType = resolvedType;
        this.rawClass = rawClass;
        this.parts = parts;
        this.helperHints = helperHints;
    }

    String getHelperHint(String part) {
        return this.helperHints.get(part);
    }

    static DotName rawClassName(String value) {
        int angleIdx = value.indexOf(LEFT_ANGLE);
        if (angleIdx != -1) {
            return DotName.createSimple((String)value.substring(0, angleIdx));
        }
        return DotName.createSimple((String)value);
    }

    static String helperHint(String part) {
        int angleIdx = part.indexOf(LEFT_ANGLE);
        if (angleIdx == -1) {
            return null;
        }
        return part.substring(angleIdx, part.length());
    }

    static Type resolveType(String value) {
        int angleIdx = value.indexOf(LEFT_ANGLE);
        if (angleIdx == -1) {
            return Type.create((DotName)DotName.createSimple((String)value), (Type.Kind)Type.Kind.CLASS);
        }
        String name = value.substring(0, angleIdx);
        DotName rawName = DotName.createSimple((String)name);
        String[] parts = value.substring(angleIdx + 1, value.length() - 1).split(",");
        Type[] arguments = new Type[parts.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = TypeCheckInfo.resolveType(parts[i]);
        }
        return ParameterizedType.create((DotName)rawName, (Type[])arguments, null);
    }
}

