/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.Escaper;
import io.quarkus.qute.Expression;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.RawString;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.VariantTemplateProducer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class EngineProducer {
    public static final String INJECT_NAMESPACE = "inject";
    private static final Logger LOGGER = Logger.getLogger(EngineProducer.class);
    @Inject
    Event<EngineBuilder> event;
    private volatile Engine engine;
    private volatile List<String> tags;
    private volatile List<String> suffixes;
    private volatile String basePath;
    private volatile String tagPath;

    void init(QuteConfig config, List<String> resolverClasses, List<String> templatePaths, List<String> tags) {
        if (this.engine != null) {
            LOGGER.warn((Object)"Qute already initialized!");
            return;
        }
        LOGGER.debugf("Initializing Qute with: %s", resolverClasses);
        this.suffixes = config.suffixes;
        this.basePath = "templates/";
        this.tagPath = this.basePath + "tags/";
        EngineBuilder builder = Engine.builder().addDefaultSectionHelpers();
        builder.addValueResolver(ValueResolvers.thisResolver());
        builder.addValueResolver(ValueResolvers.orResolver());
        builder.addValueResolver(ValueResolvers.trueResolver());
        builder.addValueResolver(ValueResolvers.collectionResolver());
        builder.addValueResolver(ValueResolvers.mapperResolver());
        builder.addValueResolver(ValueResolvers.mapEntryResolver());
        builder.addValueResolver(ValueResolvers.rawResolver());
        final Escaper htmlEscaper = Escaper.builder().add('\"', "&quot;").add('\'', "&#39;").add('&', "&amp;").add('<', "&lt;").add('>', "&gt;").build();
        builder.addResultMapper(new ResultMapper(){

            public boolean appliesTo(TemplateNode.Origin origin, Object result) {
                return !(result instanceof RawString) && origin.getVariant().filter(EngineProducer::requiresDefaultEscaping).isPresent();
            }

            public String map(Object result, Expression expression) {
                return htmlEscaper.escape((CharSequence)result.toString());
            }
        });
        builder.addValueResolver((ValueResolver)new ReflectionValueResolver());
        this.event.fire((Object)builder);
        builder.addNamespaceResolver(NamespaceResolver.builder((String)INJECT_NAMESPACE).resolve(ctx -> {
            InstanceHandle bean = Arc.container().instance(ctx.getName());
            return bean.isAvailable() ? bean.get() : Results.Result.NOT_FOUND;
        }).build());
        for (String resolverClass : resolverClasses) {
            builder.addValueResolver(this.createResolver(resolverClass));
            LOGGER.debugf("Added generated value resolver: %s", (Object)resolverClass);
        }
        this.tags = tags;
        for (String tag : tags) {
            String tagName = tag.contains(".") ? tag.substring(0, tag.lastIndexOf(46)) : tag;
            LOGGER.debugf("Registered UserTagSectionHelper for %s", (Object)tagName);
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName));
        }
        builder.addLocator(this::locate);
        this.engine = builder.build();
        for (String path : templatePaths) {
            this.engine.getTemplate(path);
        }
    }

    @Produces
    @ApplicationScoped
    Engine getEngine() {
        return this.engine;
    }

    String getBasePath() {
        return this.basePath;
    }

    String getTagPath() {
        return this.tagPath;
    }

    List<String> getSuffixes() {
        return this.suffixes;
    }

    private ValueResolver createResolver(String resolverClassName) {
        try {
            Class<?> resolverClazz = Thread.currentThread().getContextClassLoader().loadClass(resolverClassName);
            if (ValueResolver.class.isAssignableFrom(resolverClazz)) {
                return (ValueResolver)resolverClazz.newInstance();
            }
            throw new IllegalStateException("Not a value resolver: " + resolverClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Unable to create resolver: " + resolverClassName, e);
        }
    }

    private Optional<TemplateLocator.TemplateLocation> locate(String path) {
        URL resource = null;
        if (this.tags.stream().anyMatch(tag -> tag.startsWith(path))) {
            LOGGER.debugf("Locate tag for %s", (Object)path);
            resource = this.locatePath(this.tagPath + path);
            for (String suffix : this.suffixes) {
                resource = this.locatePath(this.tagPath + path + "." + suffix);
                if (resource == null) continue;
                break;
            }
        }
        if (resource == null) {
            String templatePath = this.basePath + path;
            LOGGER.debugf("Locate template for %s", (Object)templatePath);
            resource = this.locatePath(templatePath);
        }
        if (resource != null) {
            return Optional.of(new ResourceTemplateLocation(resource, EngineProducer.guessVariant(path)));
        }
        return Optional.empty();
    }

    private URL locatePath(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = EngineProducer.class.getClassLoader();
        }
        return cl.getResource(path);
    }

    static Variant guessVariant(String path) {
        int suffixIdx = path.lastIndexOf(46);
        if (suffixIdx != -1) {
            String suffix = path.substring(suffixIdx);
            return new Variant(null, VariantTemplateProducer.parseMediaType(suffix), null);
        }
        return null;
    }

    static boolean requiresDefaultEscaping(Variant variant) {
        return variant.mediaType != null ? "text/html".equals(variant.mediaType) || "text/xml".equals(variant.mediaType) : false;
    }

    static class ResourceTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final URL resource;
        private final Optional<Variant> variant;

        public ResourceTemplateLocation(URL resource, Variant variant) {
            this.resource = resource;
            this.variant = Optional.ofNullable(variant);
        }

        public Reader read() {
            try {
                return new InputStreamReader(this.resource.openStream(), Charset.forName("utf-8"));
            }
            catch (IOException e) {
                return null;
            }
        }

        public Optional<Variant> getVariant() {
            return this.variant;
        }
    }
}

